--------------------------------------------------------------------------------
-- DIO2 board LCD driver
-- top level testbench
--
-- Michal TRS
-- trsm1@fel.cvut.cz 
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;

ENTITY lcd_tb_vhd IS
END lcd_tb_vhd;

ARCHITECTURE behavior OF lcd_tb_vhd IS 

	-- Component Declaration for the Unit Under Test (UUT)
	COMPONENT lcd
	PORT(
		CLK : IN std_logic;
		AS_RESET : IN std_logic;
		OPER : IN std_logic_vector(1 downto 0);
		ASCII : IN std_logic_vector(7 downto 0);
		VLD : IN std_logic;          
		RDY : OUT std_logic;
		DATA : OUT std_logic_vector(7 downto 0);
		RS : OUT std_logic;
		RW : OUT std_logic;
		E : OUT std_logic
		);
	END COMPONENT;

	--Inputs
	SIGNAL CLK :  std_logic := '0';
	SIGNAL AS_RESET :  std_logic := '0';
	SIGNAL VLD :  std_logic := '0';
	SIGNAL OPER :  std_logic_vector(1 downto 0) := (others=>'0');
	SIGNAL ASCII :  std_logic_vector(7 downto 0) := (others=>'0');

	--Outputs
	SIGNAL RDY :  std_logic;
	SIGNAL DATA :  std_logic_vector(7 downto 0);
	SIGNAL RS :  std_logic;
	SIGNAL RW :  std_logic;
	SIGNAL E :  std_logic;

BEGIN

	-- Instantiate the Unit Under Test (UUT)
	uut: lcd PORT MAP(
		CLK => CLK,
		AS_RESET => AS_RESET,
		OPER => OPER,
		ASCII => ASCII,
		VLD => VLD,
		RDY => RDY,
		DATA => DATA,
		RS => RS,
		RW => RW,
		E => E
	);

   CLK <= not CLK after 10 ns;

	tb : PROCESS
	BEGIN

      AS_RESET <= '1';
		-- Wait 100 ns for global reset to finish
		wait for 500 ns;
      AS_RESET <= '0';

		-- Place stimulus here

      wait until RDY = '1';
      OPER <= "10";
      VLD <= '1';
      ASCII <= "00000000";
      wait until CLK = '1';
      VLD <= '0';

      wait until RDY = '1';
      OPER <= "11";
      ASCII <= X"44";
      VLD   <= '1';
      wait until CLK = '1';
      VLD   <= '0';

      wait for 3 ms;
      
		wait; -- will wait forever
	END PROCESS;

END;
