#include <stdio.h>

#include "types.h"
#include "debug.h"


#ifdef DEBUG
 
extern FILE *efp;

void debug_message(char *msg) {
	if (efp == NULL)
    	return;
	fprintf(efp, "%s", msg);
	fflush(efp);
}

#ifdef DEBUG_UART
/* print a hex number on the debug interface */
void put_hex(bool_t in, u08_t val) {
  u08_t n;

  if (efp == NULL)
    return;
  
  if(in) fputc('>', efp);
  else   fputc('<', efp);

  n = val>>4;
  if(n<10) fputc('0'+n, efp);
  else     fputc('a'+n-10, efp);

  n = val&0x0f;
  if(n<10) fputc('0'+n, efp);
  else     fputc('a'+n-10, efp);

  fputc(' ', efp);
}
#endif

#endif

