/*
  hci_callback.c
*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/

#include <stdio.h>
#include <stdlib.h>

#include "types.h"
#include "debug.h"
#include "hci_callback.h"
#include "hci_con.h"

extern FILE *efp;
extern hci_l2con_t *l2con;
extern int eth_connected;
extern int bt_connected;

bool_t hci_internal_callback(u08_t type, void *data) {
  hci_event_t evt;

  evt.type = type;
  evt.data = data;

  /* forward data to internal layers first */
  /* the simple BlueM3 does not have internal layers ... */

  /* forward everything to the application callback */
  return hci_event_callback(&evt);
}

bool_t hci_event_callback(hci_event_t *event) {
  u16_t len;
  u08_t *buff;
  int cnt;

  /* check requesting device PSM */
  if (event->l2con->psm != APP_PSM) {
    DEBUG_L2CAP("invalid PSM\n");
    return FALSE;
  }
  
  switch(event->type) {
      /* react on an incoming connection request */
    case L2CAP_EVT_ACKNOWLEDGE_CONNECTION:
      DEBUG_L2CAP("l2cap requesting acknowledge\n");
      break;

     /* react on successful connection */
    case L2CAP_EVT_NOTIFY_CONNECTION:
      DEBUG_L2CAP("l2cap connected\n");
      bt_connected = 1;
      l2con = event->l2con;
      break;

    /* react on connection close */
    case L2CAP_EVT_NOTIFY_DISCONNECTION:
      DEBUG_L2CAP("l2cap disconnected!\n");
      bt_connected = 0;
      break;

    /* react on data */
    case L2CAP_EVT_NOTIFY_RECEIVE:
      DEBUG_L2CAP("l2cap data packet\n");	  
      if (eth_connected) {      
        len = L2LEN(event->l2con);
        buff = malloc(len);
	    l2cap_receive(event->l2con, buff, len);
        if ((cnt = fwrite(buff, 1, len, efp)) <= 0) {
          eth_connected = 0;
          break;
        }
        if (fflush(efp)) {
          eth_connected = 0;
          break;
        }  
        free(buff);
      }        
      break;
      
    default:
      DEBUG_L2CAP("unknown l2cap event!\n");
  }

  return TRUE;
}

