/*
  hci_info.h

  hci info event processing 
*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/



#include "types.h"
#include "hci.h"
#include "hci_info.h"
#include "hci_acl.h"
#include "hci_uart.h"

void hci_info_init(void) {
  hci_buffers_t buffers;

  static u08_t hci_cmd_read_bsize[] = {    
    OPCODE(OGF_INFO_PARAM, OCF_READ_BUFFER_SIZE), 0 };
  
  /* read buffer size, this is required to enable flow control */
  hci_send_cmd(hci_cmd_read_bsize, sizeof(hci_cmd_read_bsize), 
	       HCI_PARMS, &buffers);
  
  hci_acl_set(buffers.acl_num, buffers.acl_len);
}
