/*
  hci_uart.c

  hci specific helper functions for uart operation
*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/



#include "types.h"
#include "debug.h"
#include "uart.h"
#include "hci_uart.h"


void hci_uart_put(u08_t val) {
#ifdef DEBUG_UART
  put_hex(FALSE, val);
#endif
  uart_putc(val);
}

/* just echo a number of bytes */
void hci_uart_echo(u16_t len) {
  while(len--)
    hci_uart_put(hci_uart_get());
}

/* write a stream of bytes to the uart */
void hci_uart_send(u08_t *data, u16_t len) {
  while(len--) hci_uart_put(*data++);
}

/* send a 16 bit value */
void hci_uart_put_u16(u16_t val) {
  hci_uart_put(val  & 0xff);
  hci_uart_put(val >> 8);
}

/* write a stream of bytes to the uart */
void hci_uart_send_zero(u16_t len) {
  while(len--) hci_uart_put(0);
}

u08_t hci_uart_get(void) {
  u08_t i;

  while(!uart_input_avail());
  i = uart_getc();
#ifdef DEBUG_UART
  put_hex(TRUE, i);
#endif
  return i;
}

/* receive several bytes, block if no byte received yet */
void hci_uart_get_n(u08_t *data, u16_t len) {
  while(len--)
   *data++ = hci_uart_get();
}

/* drop bytes from input buffer */
void hci_uart_drop(u16_t bytes) {
  while(bytes--) hci_uart_get();
}

/* read two bytes and interprete them as a 16 bit value */
u16_t hci_uart_get_u16(void) {
  return hci_uart_get() + 256 * hci_uart_get();
}
