/*
  hci_uart.h

  hci specific helper functions for uart operation
*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/


#ifndef HCI_UART_H
#define HCI_UART_H

#include "types.h"

void hci_uart_put(u08_t a);

u08_t hci_uart_get(void);
void  hci_uart_send(u08_t *data, u16_t len);

void  hci_uart_send_zero(u16_t len);
void  hci_uart_get_n(u08_t *data, u16_t len);
void  hci_uart_drop(u16_t bytes);
u16_t hci_uart_get_u16(void);
void  hci_uart_put_u16(u16_t val);
void  hci_uart_echo(u16_t len);

#endif
