/*
  l2cap.h

*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/


#ifndef L2CAP_H
#define L2CAP_H

#include "hci_uart.h"
#include "hci_con.h"

#define L2CAP_DEFAULT_MTU 672
#define L2CAP_REQUEST_MTU 1700

/* l2cap command codes */
#define L2CAP_CMD_REJ           0x01
#define L2CAP_CON_REQ           0x02
#define L2CAP_CON_RSP           0x03
#define L2CAP_CONF_REQ          0x04
#define L2CAP_CONF_RSP          0x05
#define L2CAP_DISC_REQ          0x06
#define L2CAP_DISC_RSP          0x07
#define L2CAP_ECHO_REQ          0x08
#define L2CAP_ECHO_RSP          0x09
#define L2CAP_INFO_REQ          0x0a
#define L2CAP_INFO_RSP          0x0b

/* connection response code */
#define L2CAP_CON_RSP_SUCCESS   0x00
#define L2CAP_CON_RSP_PENDING   0x01
#define L2CAP_CON_RSP_ILLPSM    0x02
#define L2CAP_CON_RSP_SECURITY  0x03
#define L2CAP_CON_RSP_RESOURCE  0x04

/* configuration response codes */
#define L2CAP_CONF_RSP_SUCCESS  0x00
#define L2CAP_CONF_RSP_FAILPARM 0x01
#define L2CAP_CONF_RSP_FAILREJ  0x02
#define L2CAP_CONF_RSP_FAILUNK  0x03

/* l2cap option codes */
#define L2CAP_OPTION_MTU        0x01    // maximum transmission unit
#define L2CAP_OPTION_FTO        0x02    // flush timeout option
#define L2CAP_OPTION_QOS        0x03    // quality of service

/* l2cap internal functions */
void    l2cap_decode(hci_acl_con_t *acl, u16_t len);
void    l2cap_link_broken(hci_acl_con_t *acl);

/* functions to be used by upper layers */
void    l2cap_receive(hci_l2con_t *l2con, u08_t *buffer, u16_t len);
u08_t   l2cap_receive_u08(hci_l2con_t *l2con);
void    l2cap_send(hci_l2con_t *l2con, void *buffer, u16_t len);

#define L2LEN(l2con)  (((hci_acl_con_t*)l2con->acl)->l2cap_expect)
#define L2SDP(l2con)  (((hci_acl_con_t*)l2con->acl)->sdp)

#endif //L2CAP_H
