/*
  uart.c
*/

#include <stdio.h>

#include "types.h"
#include "uart.h"

extern FILE *ufp;

/* check if data is available from bluetooth uart */
u08_t uart_input_avail(void) {
  int chr;

  if ((chr = fgetc(ufp)) == EOF) {
    return 0;
  } else {
    ungetc(chr, ufp);
    return 1;
  }
}

/* read a byte from bluetooth uart */
u08_t uart_getc(void) {
  return fgetc(ufp);
}

/* write to bluetooth uart */
void uart_putc(u08_t chr) {
  fputc(chr, ufp);
}

