
--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   10:42:58 11/22/2006
-- Design Name:   cpu_ent
-- Module Name:   cpu_tb.vhd
-- Project Name:  CPU
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: cpu_ent
--
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends 
-- that these types always be used for the top-level I/O of a design in order 
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;

ENTITY cpu_tb_vhd IS
END cpu_tb_vhd;

ARCHITECTURE behavior OF cpu_tb_vhd IS 

	-- Component Declaration for the Unit Under Test (UUT)
	COMPONENT cpu
	PORT(
		CLK : IN std_logic;
		RESET : IN std_logic;
		SRAM_TX_ACK : IN std_logic;
		SRAM_RX_DATA : IN std_logic_vector(7 downto 0);
		SRAM_RX_VALID : IN std_logic;
		COM_TX_ACK : IN std_logic;
		COM_RX_DATA : IN std_logic_vector(7 downto 0);
		COM_RX_VALID : IN std_logic;
		GPS_TX_ACK : IN std_logic;
		GPS_RX_DATA : IN std_logic_vector(7 downto 0);
		GPS_RX_VALID : IN std_logic;
		GLCD_TX_ACK : IN std_logic;          
		SRAM_TX_DATA : OUT std_logic_vector(7 downto 0);
		SRAM_TX_VALID : OUT std_logic;
		SRAM_RX_ACK : OUT std_logic;
		COM_TX_DATA : OUT std_logic_vector(7 downto 0);
		COM_TX_VALID : OUT std_logic;
		COM_RX_ACK : OUT std_logic;
		GPS_TX_DATA : OUT std_logic_vector(7 downto 0);
		GPS_TX_VALID : OUT std_logic;
		GPS_RX_ACK : OUT std_logic;
		GLCD_TX_DATA : OUT std_logic_vector(7 downto 0);
		GLCD_TX_VALID : OUT std_logic
		);
	END COMPONENT;

	--Inputs
	SIGNAL CLK :  std_logic := '0';
	SIGNAL RESET :  std_logic := '0';
	SIGNAL SRAM_TX_ACK :  std_logic := '0';
	SIGNAL SRAM_RX_VALID :  std_logic := '0';
	SIGNAL COM_TX_ACK :  std_logic := '0';
	SIGNAL COM_RX_VALID :  std_logic := '0';
	SIGNAL GPS_TX_ACK :  std_logic := '0';
	SIGNAL GPS_RX_VALID :  std_logic := '0';
	SIGNAL GLCD_TX_ACK :  std_logic := '0';
	SIGNAL SRAM_RX_DATA :  std_logic_vector(7 downto 0) := (others=>'0');
	SIGNAL COM_RX_DATA :  std_logic_vector(7 downto 0) := (others=>'0');
	SIGNAL GPS_RX_DATA :  std_logic_vector(7 downto 0) := (others=>'0');

	--Outputs
	SIGNAL SRAM_TX_DATA :  std_logic_vector(7 downto 0);
	SIGNAL SRAM_TX_VALID :  std_logic;
	SIGNAL SRAM_RX_ACK :  std_logic;
	SIGNAL COM_TX_DATA :  std_logic_vector(7 downto 0);
	SIGNAL COM_TX_VALID :  std_logic;
	SIGNAL COM_RX_ACK :  std_logic;
	SIGNAL GPS_TX_DATA :  std_logic_vector(7 downto 0);
	SIGNAL GPS_TX_VALID :  std_logic;
	SIGNAL GPS_RX_ACK :  std_logic;
	SIGNAL GLCD_TX_DATA :  std_logic_vector(7 downto 0);
	SIGNAL GLCD_TX_VALID :  std_logic;

BEGIN

	-- Instantiate the Unit Under Test (UUT)
	uut: cpu PORT MAP(
		CLK => CLK,
		RESET => RESET,
		SRAM_TX_DATA => SRAM_TX_DATA,
		SRAM_TX_VALID => SRAM_TX_VALID,
		SRAM_TX_ACK => SRAM_TX_ACK,
		SRAM_RX_DATA => SRAM_RX_DATA,
		SRAM_RX_VALID => SRAM_RX_VALID,
		SRAM_RX_ACK => SRAM_RX_ACK,
		COM_TX_DATA => COM_TX_DATA,
		COM_TX_VALID => COM_TX_VALID,
		COM_TX_ACK => COM_TX_ACK,
		COM_RX_DATA => COM_RX_DATA,
		COM_RX_VALID => COM_RX_VALID,
		COM_RX_ACK => COM_RX_ACK,
		GPS_TX_DATA => GPS_TX_DATA,
		GPS_TX_VALID => GPS_TX_VALID,
		GPS_TX_ACK => GPS_TX_ACK,
		GPS_RX_DATA => GPS_RX_DATA,
		GPS_RX_VALID => GPS_RX_VALID,
		GPS_RX_ACK => GPS_RX_ACK,
		GLCD_TX_DATA => GLCD_TX_DATA,
		GLCD_TX_VALID => GLCD_TX_VALID,
		GLCD_TX_ACK => GLCD_TX_ACK
	);

	clk <= not clk after 50 ns;

	tb : PROCESS
	BEGIN

		-- Wait 100 ns for global reset to finish
		reset <= '1';
		wait for 100 ns;
		reset <= '0';
		wait for 1 us;

		-- Place stimulus here

		gps_rx_data <= X"a5";
		gps_rx_valid <= '1';

		wait until gps_rx_ack = '1';
		wait for 100 ns;
		gps_rx_valid <= '0';		
--		wait until gps_rx_ack = '0';

		wait until sram_tx_valid = '1';
		wait for 100 ns;
		sram_tx_ack <= '1';		
		wait until sram_tx_valid = '0';
		wait for 100 ns;
		sram_tx_ack <= '0';		

		wait; -- will wait forever
	END PROCESS;

END;
