// UPRAVENA FUNKCE SENDTO

// Funkce sendto_ ma stejne parametry jako funkce sendto.
// Funkce simuluje chovani chybujici linky s vice smerovaci, tzn. ze pakety
// ztraci, duplikuje i prohazuje.
//
// Navod k pouziti:
//
// Na zacatek vaseho zdrojoveho kodu uvedte:
//	#include "sendto_.c"
// Misto kazdeho pouziti funkce sendto volejte sendto_.
// Pokud si neprejete vypisovat ladici hlaseni, zakomentujte
// nasledujici direktivu:

#define LADICI_HLASENI

//-----------------------------------------------------------------

#ifndef INC_SENDTO_
#define INC_SENDTO_

#include<time.h>
#include<stdlib.h>

#define BUFFER_SIZE	1024

//buffer pro nahodne duplikace
char buffer[BUFFER_SIZE];
int buffer_len;
char poprve = 1;

int sendto_(int sockfd,  const void *buf, int buf_len, unsigned int flags, const struct sockaddr *to, int to_len)
{
    int r, retcode;
    char duplikovat;

    if (buf_len > BUFFER_SIZE)
    {
        printf("Je treba zvetsit hodnotu BUFFER_SIZE v souboru sendto_.c\n");
        return -1;
    }
    
    if (poprve)
    {
	srand(time(NULL));
	poprve = 0;
    }
    r = 0x07 & random();
    duplikovat = r & 0x04;
    r &= 0x03;

    if (!r)
    {
#ifdef LADICI_HLASENI
        printf("sendto_: NEODESLANO\n");
#endif    
        return buf_len;
    }
    
    while (r--)
    {
#ifdef LADICI_HLASENI
        printf("sendto_: ODESLANO\n");
#endif
	retcode = sendto(sockfd,buf,buf_len,flags,to,to_len);
    }      

    if (buffer_len)
    {
#ifdef LADICI_HLASENI
	printf("sendto_: ODESLASNA PREDCHOZI ZPRAVA\n");
#endif
	sendto(sockfd,buffer,buf_len,flags,to,to_len);
	buffer_len = 0;
    }

    if (duplikovat)
    {
    	buffer_len = buf_len;		// zkopirovnani zpravy do bufferu sendto_
	bcopy( buf, buffer, buf_len);	// priste se to odesle
    }
    return retcode;
}

#endif
