/* 
 * DSY uloha2 - Michal Trs 
 * UDP client - plovouci okenko
 */

#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <errno.h> 
#include <stdio.h>
#include <stdlib.h>
#include <sys\timeb.h>
#include "sendto_.c"
#include "sup_func.h"


int main(int argc, char *argv[]) {
    
   MSG msg;            // UDP packet (BYTE 0 - id, BYTE 1 - EOTrans)
   WINDOW window;      // okno
   unsigned char id,ack;             // cislo zpravy, cislo potvrzene zpravy
    
   FILE *f;            // file to send
   unsigned char trueLen;      // delka dat nactenych ze souboru
    
   struct sockaddr_in mAddr, rAddr;	  // adresy
   int rAddrLen;				          // delka rAddr
   int sockfd;					          // cislo soketu
   
   fd_set read_set, write_set, other_set;
   struct timeval timeout;

   int selRet;
	
   int i;
   
   int rnd;

   //--------------------
    
   if (argc != 4) {
      printf("Usage: %s file_to_send server_ip port_number",argv[0]);         
      exit(1);
   }
    
   if ((f = fopen(argv[1],"rb")) == NULL) {
      perror("Can't open file");
      exit(1);   
   }
    
   //------------------------------------------------------------
    
   if ((sockfd = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
      // vytvoreni soketu
      perror("cannot open socket");
      exit(1);
   }

   bzero((char *) &mAddr, sizeof(mAddr));
   // vytvoreni valstni adresy
   mAddr.sin_family = AF_INET;
   mAddr.sin_addr.s_addr = INADDR_ANY;
   mAddr.sin_port = 0;
   if (bind(sockfd, (struct sockaddr *) &mAddr, sizeof(mAddr)) < 0) {
      perror("cannot bind socket");
      close(sockfd);
      exit(1);
   }
   
   bzero ((char *) &rAddr, sizeof(rAddr));
   rAddr.sin_family = AF_INET;
   rAddr.sin_addr.s_addr = inet_addr(argv[2]);
   rAddr.sin_port = htons(atoi(argv[3])); 

   //------------------------------------------------------------
   id = 0;
   for (i=0; i < WIN_SIZE; i++) 
      window[i].used = 0;    
 
   while (!feof(f) || window[0].used || window[1].used || window[2].used || window[3].used) {
      // posilani msg
          
      for (i=0; i<WIN_SIZE; i++) {
         if (window[i].used == 0) { 
            if (feof(f)) continue; // konec souboru - jen posli neodeslane
            window[i].used = 1;                                  
            window[i].msg[0] = id++ % 256;
            trueLen = (unsigned char) fread(&window[i].msg[2],1,SIZE-2,f);
            if (trueLen < SIZE-2) trueLen += 128;        // konec souboru +128
            window[i].msg[1] = trueLen;
            if (sendto_(sockfd, window[i].msg, SIZE, 0, (struct sockaddr *) &rAddr, sizeof(rAddr)) < 0) {
			   perror("error in broadcast");
			   close(sockfd);
			   exit(1);
            } 
            setAktTime(&window[i].time);
            printf("sended packet %d\n",(int)window[i].msg[0]);
            
               
         } else { 
            if (isTimeout(window[i].time)) {
               if (sendto_(sockfd, window[i].msg, SIZE, 0, (struct sockaddr *) &rAddr, sizeof(rAddr)) < 0) {
                  perror("error in broadcast");
			      close(sockfd);
			      close(f);
			      exit(1);
               }
               setAktTime(&window[i].time); 
               printf("timeout - sended paket %d\n",window[i].msg[0]);
            } 
         }   
      } // for
    
      // prijimani ack
          
      FD_ZERO(&read_set);
      FD_SET(sockfd,&read_set);
      timeout.tv_sec = TIMEOUT;
      timeout.tv_usec = 0;
      
      selRet = select(5,&read_set,NULL,NULL,&timeout);
      
      if (selRet == -1)    // select se nepovedl
         perror("error select()");         
      else if (selRet) {   // prijmu ack                                                   
         rAddrLen = sizeof(rAddr);
         if (recvfrom(sockfd, &ack, 1, 0, (struct sockaddr *) &rAddr, &rAddrLen) < 0 ) {
            perror("error in listen");
	        close(sockfd);
	        exit(1);
         } 
         printf("received ACK %d\n",(int)ack); 
      }

      // uvolnim potvrzene
      for (i=0; i < WIN_SIZE; i++) {
         if ( isLess(window[i].msg[0],ack) ) window[i].used = 0;
         //           0                   252 
      }
     
      if (INFO) {
         printf("----info----\n");   
         for (i=0; i < WIN_SIZE; i++) {
            printf("okno %d id %d used %d\n",i,(int)window[i].msg[0],window[i].used);
         }
         printf("------------\n");     
      }
    
   } // while
    
   close(f);
}
