/* 
 * DSY uloha1 - Michal Trs 
 * UDP server - plovouci okenko
*/ 


#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include "sendto_.c"
#include "sup_func.h"



int main(int argc, char *argv[]) {
    
   MSG msg;            // UDP packet
   WINDOW window;      // okno
    
   unsigned char lastAck;        // posledni odeslane Ack
   int winStart;       // pocatek okna
   int lastMsg=0;      // prisel posledni packet?
   unsigned char trueLen;       // velikost prijateho paketu
   int last;           // posledni souvisli zaznam
   
   
   unsigned char id;            // cislo paketu   
    
   FILE *f;            // receive file
    
   struct sockaddr_in mAddr, rAddr;	  // adresy
   int rAddrLen;				          // delka rAddr
   int sockfd;					          // cislo soketu
	
   int i,p;

   //--------------------
    
   if (argc != 2) {
      printf("Usage: %s port_number",argv[0]);       
      exit(1);  
   }
    
   //------------------------------------------------------------
    
   if ((sockfd = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
      // vytvoreni soketu
      perror("cannot open socket");
      exit(1);
   }
	
   bzero((char *)&mAddr, sizeof(mAddr));
   // vytvoreni vlastni adresy
   mAddr.sin_family = AF_INET;
   mAddr.sin_addr.s_addr = INADDR_ANY;
   mAddr.sin_port = htons(atoi(argv[1]));
   if (bind(sockfd, (struct sockaddr *) &mAddr, sizeof(mAddr)) < 0) {
      perror("cannot bind socket");
	  close(sockfd);
	  exit(1);
   }
	
   //------------------------------------------------------   
   
   for (i=0; i < WIN_SIZE; i++)
      window[i].used = 0;
    
   winStart = 0;
   lastAck = 0;
     
   if ((f = fopen("recDada.dat","wb")) == NULL) {
      perror("Can't open file");
      exit(1);   
   }
   
   //----------------------------------------------------
       
   while (window[0].used || window[1].used || window[2].used || window[3].used || !lastMsg) {
         
      // ----prijmu paket---------------
      rAddrLen = sizeof(rAddr);
	  if (recvfrom(sockfd, msg, SIZE, 0, (struct sockaddr *) &rAddr, &rAddrLen) < 0 ) {
	     perror("error in listen");
	     close(sockfd);
	     exit(1);
      }   
      
      id = msg[0];
      printf("received packet %d\n",(int)id);
      
      trueLen = msg[1];
      if (trueLen >= 128) { // posledni paket
         trueLen -= 128;
         lastMsg = 1;
      }

      if (isLess(winStart,id) && isLess(id,((int)(winStart) + WIN_SIZE-1))%SIZE) { // patri do okenka
         for (i=0; i<SIZE; i++)
            window[id - winStart].msg[i] = msg[i];
         window[id - winStart].used = 1;
         window[id - winStart].trueLen = trueLen;
      
      
         // najdu posledni souvisly paket v okenku
         for (last=0; last < WIN_SIZE; last++)
           if (!window[last].used) break;
        last--;
              
         // ulozim je do souboru
         if (last >=0) {
            lastAck = window[last].msg[0];
            winStart = (lastAck+1) % 256;
            for (i=0; i < WIN_SIZE; i++) {
               if (i <= last)              
                  if (fwrite(&window[i].msg[2],1,window[i].trueLen,f) != window[i].trueLen) {
                     perror("error in saving file");
                     close(sockfd);
                     close(f);
                     exit(1);                                          
                  }
                  
               // posunu okenko
               if (last+1 + i < WIN_SIZE) {
                  for (p=0; p<SIZE; p++)
                     window[i].msg[p] = window[last+1 + i].msg[p];
                  window[i].used = window[last+1 + i].used;
                  window[i].trueLen = window[last+1 + i].trueLen;
                  
               } else
                  window[i].used = 0;
            } // for
         } // if   
      
      } // if - je v okne
      
      // poslu ack
      if (sendto_(sockfd, &lastAck, 1, 0, (struct sockaddr *) &rAddr, sizeof(rAddr)) < 0) {
         perror("error in sending Ack");
         close(sockfd);
         exit(1);
      } 
      printf("sended ACK %d\n",(int)lastAck);

      if (INFO) {
         printf("----info----\nZacatek okna: %d\n",winStart);   
         for (i=0; i < WIN_SIZE; i++) {
            printf("okno %d id %d used %d\n",i,(int)window[i].msg[0],window[i].used);
         }
         printf("------------\n");
      }
             
          
   } // while 
   printf("end\n");
    
   close(f); 
    
       
    
    
}
    
