/* types.h 
 * define ETH, IP, TCP header
 *
 * Michal Trs, Jirka Sejtko
 * CVUT FEL, K336
 */

#ifndef __TYPES_H_766387632_
#define __TYPES_H_766387632_

#include <pcap.h>


#define ETH_HDR_LEN		14		// Ethernet header lenght
#define L5_PROTOCOL		21		// FTP

#define FILTER_BUF_SIZE 1024	// max. filter string size
#define IP_ADDR_LEN		30		// IPv4 address lenght + port number (for string)
#define SNAP_LEN		1518	// max. bytes per packet to capture
#define NUM_PACKETS		9999	// max. num. of packets to capture



/* Ethernet2 header */
typedef struct eth_header{
	u_char dst_addr[6];
	u_char src_addr[6];
	u_short proto;	
} eth_header;


/* 4 bytes IP address */
typedef struct ip_address{
    u_char byte1;
    u_char byte2;
    u_char byte3;
    u_char byte4;
}ip_address;


/* IPv4 header */
typedef struct ip_header{
    u_char  ver_ihl;        // Version (4 bits) + Internet header length (4 bits)
    u_char  tos;            // Type of service 
    u_short tlen;           // Total length 
    u_short identification; // Identification
    u_short flags_fo;       // Flags (3 bits) + Fragment offset (13 bits)
    u_char  ttl;            // Time to live
    u_char  proto;          // Protocol
    u_short crc;            // Header checksum
    ip_address  saddr;      // Source address
    ip_address  daddr;      // Destination address
    u_int   op_pad;         // Option + Padding
}ip_header;


/* TCP header*/
typedef struct tcp_header{
    u_short		sport;
    u_short		dport;
    u_int		seqnum;
    u_int		acknum;
	u_char		data_ofs_res;
	u_char		flags;
    u_short		window;
    u_short		checksum;
    u_short		urgent_ptr;
    /* u_int options:? */
} tcp_header;


/* TCP option */
typedef struct tcp_options{
	u_char		kind;
	u_char		lenght;		
	u_short		mss;
} tcp_options;


/* TCP flag function */
bool cwr(u_char flags);
bool ece(u_char flags);
bool urg(u_char flags);
bool ack(u_char flags);
bool psh(u_char flags);
bool rst(u_char flags);
bool syn(u_char flags);
bool fin(u_char flags);


/* from: http://en.wikipedia.org/wiki/Image:800px-TCP_state_diagram.png */
typedef enum tcp_state {
	TCS_CLOSED, TCS_LISTEN, TCS_SYN_RCVD, TCS_SYN_SENT, TCS_ESTABILISHED,
	TCS_FIN_WAIT1, TCS_FIN_WAIT2, TCS_CLOSING, TCS_TIMED_WAIT, TCS_CLOSE_WAIT,
	TCS_LAST_ACK } tcp_state;


/* tcp packet data structure */
typedef struct tcp_packet {							
	struct timeval ts;						/* capture time */
	u_int32_t seq;							/* TCP packet sequence number */
	u_int16_t len;							/* data length */
	u_char data[SNAP_LEN];					/* data */
} tcp_packet;

#endif





