#!/bin/bash
# Michal Trs
#
# 36NAN - strom telecom data
#
# redukuje data

function incc {
   awk 'BEGIN {MAX = 8000} # maximalni pocet radku vystupniho souboru
              {hist[$0]++}
        END   {for (i in hist) { 
                 cnt = hist[i]/(NR/MAX); # v tomto pomeru jsou data redukovany
                 for (j=0; j < cnt; j++) { # j == 0 - povolim jakykoli vyskyt
                   print i;
                 }
              }}' $@;
}

function decc {
   awk 'BEGIN {MAX = 8000} # maximalni pocet radku vystupniho souboru
              {hist[$0]++}
        END   {for (i in hist) { 
                 cnt = hist[i]/(NR/MAX); # v tomto pomeru jsou data redukovany
                 for (j=1; j < cnt; j++) { # j == 0 - povolim jakykoli vyskyt
                   print i;
                 }
              }}' $@;
}

use_ran=0;
use_inc=0;

# nacist parametr

while getopts ir volba
  do
    case $volba in
	    r)   use_ran=1;;
	    i)   use_inc=1;;
	    \?)  exit 2;;
    esac
  done

shift `expr $OPTIND - 1` 


if [[ $# == 0 ]]; then
 # z pipe
   cat > tmp.$$;
else
  # ze souboru 
   cat $1 > tmp.$$;
fi;


  if [ $use_inc -ne 0 ]; then
    incc tmp.$$;
  else
    if [ $use_ran -ne 0 ]; then
      awk 'rand() > 0.99 {print $0}' tmp.$$;
    else  
      decc tmp.$$;
    fi;
  fi;
  
  
  

rm -f tmp.$$;
