#!/bin/bash
# Michal Trs
#
# 36NAN - strom telecom data
# prevod vystupu z preprocess.sh do arff (Weka format)
# Vstup: 5 sloupcu na stdin nebo soubor
#  1 - den v tydnu (E):       0 - 6
#  2 - hodina ve dni (E):     0 - 23
#  3 - prichozi ustredna (K): cislovano od 0
#  4 - odchozi ustredna (L):  cislovano od 0
#  5 - zpusob ukonceni (M):   3 (uspech) -> 1, ostatni (neuspech) -> 0
#
#  Vystup: do souboru telecom.pat
#  


function header {
  pat=`cat tmp1.$$ | wc -l`;
  ((pat=pat/2)); 
  echo -e "printf SNNS pattern definition file V3.2\ngenerated at " `date` \
          "\n\n\nNo. of patterns : " $pat \
          "\nNo. of input units : "`head -1 tmp1.$$ | wc -w` \
          "\nNo. of output units : "`sed 2q tmp1.$$ | tail -1 | wc -w` \
          "\n\n# 1(K) - idenitifikace prichoziho smeru hovoru" \
          "\n# 2(L) - idenitifikace odchoziho smeru hovoru" \
          "\n# 3(A) - den v tydnu" \
          "\n# 4(A) - hodina ve dni" \
          "\n# vystup (M) - uspesnost hovoru\n"
}

outfile="telecom.pat"

while getopts o: volba
  do
    case $volba in
	    o)   outfile=$OPTARG;;
	    \?)  exit 2;;
    esac
  done

shift `expr $OPTIND - 1` 


if [[ $# == 0 ]]; then
 # zpracovani v pipe
   cat > tmp.$$;
else
   cat $1 > tmp.$$;
fi;

d1=`cut -d' ' -f3 tmp.$$ | sort -n -u | tail -1`;
d2=`cut -d' ' -f4 tmp.$$ | sort -n -u | tail -1`;


if [[ d1 < d2 ]]; then 
   d1=$d2;
fi;


awk -v unr=$d1 'BEGIN {}
   {printf "%.2f ", $1/7; printf "%.2f ", $2/24; printf "%.2f ", $3/unr; 
   printf "%.2f ", $4/unr ; print "" ; print $5'} tmp.$$ > tmp1.$$


header tmp1.$$ > $outfile;
cat tmp1.$$ >> $outfile;

rm -f tmp*.$$;
