using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace Batoh_experiment
{
    class Program
    {
        static int mult = 10;

        static StreamReader sr;
        static StreamWriter sw;
        static StreamWriter sws;


        static void Main(string[] args)
        {
            if (args.Length == 2)
            {
                mult = int.Parse(args[1]);
            }
            else
            {
                if (args.Length != 1)
                {
                    Console.WriteLine("Knapsack problem (compare methods)");
                    Console.WriteLine("Usage: Batoh_experiment.exe input_file.txt");
                    return;
                }
            }

            string line = "";
            int instanceCnt = 0;
            int tBF = 0;
            int tDyn = 0;
            int tBB = 0;
            int tGP = 0;
            int tGPM = 0;
            Batoh b = null;


            sr = new StreamReader(args[0]);
            sw = new StreamWriter(Path.GetFileNameWithoutExtension(args[0]) + ".out.txt");
            sws = new StreamWriter(Path.GetFileNameWithoutExtension(args[0]) + ".summary.out.txt",true);
            sw.WriteLine("ID\tn\tcena\tcas\talgoritmus");
            sw.WriteLine("==\t=\t====\t===\t==========");

            //sws.WriteLine("inst.\tBF\tB&B\tDyn\tGP\tGPM");
            //sws.WriteLine("=====\t==\t===\t===\t==\t===");

            int n = 0;
            int BFres = 0;
            int GPres = 0;
            int GPMres = 0;

            float GPerr = 0;
            float GPMerr = 0;

            while ((line = sr.ReadLine()) != null)
            {
                b = new BruteForce(line);
                BFres = b.Compute();
                sw.WriteLine(b);
                tBF += b.operCnt;

                b = new BB(line);
                b.Compute();
                sw.WriteLine(b);
                tBB += b.operCnt;

                b = new Dyn(line);
                b.Compute();
                sw.WriteLine(b);
                tDyn += b.operCnt;

                b = new GreedyProof(line);
                GPres = b.Compute();
                sw.WriteLine(b);
                tGP += b.operCnt;

                b = new GreedyProofMod(line);
                GPMres = b.Compute();
                sw.WriteLine(b);
                tGPM += b.operCnt;

                instanceCnt++;

                sw.WriteLine();

                GPerr += ((float)BFres - (float)GPres) / (float)BFres;
                GPMerr += ((float)BFres - (float)GPMres) / (float)BFres;
            }

            sws.WriteLine("{0}\t{1}\t{2}\t{3}\t{4}\t{5}\t{6}\t{7}", b.n, (float)tBF / (float)instanceCnt,
                     (float)tBB / (float)instanceCnt, (float)tDyn / (float)instanceCnt,
                     (float)tGP / (float)instanceCnt, (float)tGPM / (float)instanceCnt,
                     GPerr / (float)instanceCnt, GPMerr / (float)instanceCnt);
            
            sr.Close();
            sw.Close();
            sws.Close();
        }
    }
}
