/************************************************************************ 
 *  vysledek.c
 *  vysledek, tj. seznam pozic
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifdef WIN32
#include <stdlib.h>
#include <memory.h>
#endif

#include "mpi.h"


#include <stdio.h>
#include "vysledek.h"

void vysledekInit(Vysledek* vysledek) {
  if (vysledek) {
    vysledek->pocetTahu = 0;
    vysledek->pozice = 0;
  }     
}

void vysledekDeinit(Vysledek* vysledek) {
  if (vysledek) {
    vysledek->pocetTahu = 0;
    if (vysledek->pozice) {
      free((void*)vysledek->pozice);
      vysledek->pozice = 0;
    }
  }     
}

void vysledekPack(Vysledek* zdroj, Buffer* cil) {
  if (zdroj && cil) {
    int i;
	cil->velikost = 0;
	MPI_Pack(&(zdroj->pocetTahu), 1, MPI_INT, cil->buffer, cil->kapacita, &(cil->velikost), MPI_COMM_WORLD);
	for(i = 0; i < zdroj->pocetTahu; i++) {
	  pozicePack(&(zdroj->pozice[i]), cil);
	}
  }
}

void vysledekUnpack(Vysledek* cil, Buffer* zdroj) {
  if (zdroj && cil) {
    int i, count = 0;
	zdroj->pozice = 0;
	vysledekDeinit(cil);
	vysledekInit(cil);
	MPI_Unpack(zdroj->buffer, zdroj->kapacita, &(zdroj->pozice), &count, 1, MPI_INT, MPI_COMM_WORLD);
	for(i = 0; i < count; i++) {
	  Pozice poz;
	  poziceUnpack(&poz, zdroj);
	  vysledekPridejPozici(cil, poz);
	}
  }
}

void vysledekPridejPozici(Vysledek* vysledek, Pozice pozice) {
  if (vysledek) {
    if (vysledek->pozice) {
      vysledek->pozice = (Pozice*)realloc((void*)vysledek->pozice, sizeof(Pozice) * (vysledek->pocetTahu + 1));
    } else {
      vysledek->pozice = (Pozice*)malloc(sizeof(Pozice) * 1);
    }
    vysledek->pozice[vysledek->pocetTahu] = pozice;
    vysledek->pocetTahu = vysledek->pocetTahu + 1;
  } 
}

void vysledekReverze(Vysledek* vysledek) {
  if (vysledek) {
    int i, c;
    Pozice pom;
    c = vysledek->pocetTahu;
    for(i = 0; i < (c / 2); i++) {
      pom = vysledek->pozice[i];
      vysledek->pozice[i] = vysledek->pozice[c - 1 - i];
      vysledek->pozice[c - 1 - i] = pom;
    }
  }
}

void vysledekVypis(Vysledek* vysledek) {
  int i;
  printf("\nThe result is %d.\n", vysledek->pocetTahu);
  for(i = 0; i < vysledek->pocetTahu; i++) {
	printf(" x: %d \t y: %d\n", vysledek->pozice[i].x + 1, vysledek->pozice[i].y + 1);
  }
  printf("\n");
}
