/************************************************************************ 
 *  vysledek.h
 *  vysledek, tj. seznam pozic
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifndef __VYSLEDEK_H__452676721__
#define __VYSLEDEK_H__452676721__

#include "pozice.h"
#include "buffer.h"


   typedef struct {
      int pocetTahu;
      Pozice* pozice;
   } Vysledek;

   /* provede inicializaci vysledku */
   void vysledekInit(Vysledek* vysledek);
   
   /* uvolni alokovane zdroje */
   void vysledekDeinit(Vysledek* vysledek);

   /* zapakuje vysledek */
   void vysledekPack(Vysledek* zdroj, Buffer* cil);

   /* rozpakuje vysledek */
   void vysledekUnpack(Vysledek* cil, Buffer* zdroj);
   
   /* prida pozici do vysledku */
   void vysledekPridejPozici(Vysledek* vysledek, Pozice pozice);
   
   /* provede reverzi pozic ve vysledku */
   void vysledekReverze(Vysledek* vysledek);

   /* vypise vysledek na standardni vystup */
   void vysledekVypis(Vysledek* vysledek);
   
   
#endif
