/************************************************************************ 
 *  zasobnik.h
 *  zasobnik tahu
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifndef __ZASOBNIK_H__452676721__
#define __ZASOBNIK_H__452676721__

#include "tah.h"
#include "vysledek.h"
#include "sachovnice.h"

#define MAX_POSLANYCH_TAHU  10

  typedef struct {
    int velikost;
    int kapacita;
    Tah* prvky;      
  } Zasobnik;
  
  /* provede inicializaci zasobniku */
  void zasobnikInit(Zasobnik* zasobnik);
  
  /* uvolni alokovane zdroje */
  void zasobnikDeinit(Zasobnik* zasobnik);
  
  /* vlozi na zasobnik novy prvek */
  void zasobnikVloz(Zasobnik* zasobnik, Tah prvek);
  
  /* vyzvedne ze zasobniku prvek */
  Tah zasobnikVyjmi(Zasobnik* zasobnik);
  
  /* seradi tahy podle poctu obarveni, radi pouze nekolik poslednich tahu */
  /* po skonceni razeni vynuluje pocty obarveni vsech serazenych tahu */
  void zasobnikSeradTahyPodlePoctuObarveni(Zasobnik* zasobnik, int count);
  
  /* ulozi aktualni reseni do vysledku */
  void zasobnikUlozVysledek(Zasobnik* zasobnik, Vysledek* vysledek);

  /* pokusi se rozdelit zasobnik */
  int zasobnikRozdel(Zasobnik* zasobnik, Buffer* buffer, int rez);

  /* prijme zasobnik */
  void zasobnikPrijmi(Zasobnik* zasobnik, Sachovnice* sachovnice, Buffer* buffer);

#endif
