/*
 * Output.java
 *
 * Created on 8. leden 2006, 11:34
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.michaltrs;

import java.io.*;
import net.michaltrs.Lexan.LexSymbol;

/**
 *
 * @author Misak
 */
public class OutputHTML {
    private BufferedWriter br;
    private String fileName;
    private int indent = 2;    
    private boolean lw = false;
    
    /** Creates a new instance of Output */
    public OutputHTML(String fileName) throws IOException {
        br = new BufferedWriter(new FileWriter(fileName));
        this.fileName = fileName;
    }
    
    public void newLine() throws IOException {
        write("<br>");
        br.newLine();
        ind();
        lw = false;
    }
    
    public void shLeft() throws IOException {
        indent--;
        br.newLine();
        ind();
        write("</ul>\n");
        ind();
        lw = false;
    }
    
    public void shRight() throws IOException {
        br.newLine();
        ind();
        write("<ul>");
        br.newLine();
        indent++;
        ind();
        lw = false;
    }
    
    public void space() throws IOException {
        if (lw) write(" ");
    }
    
    private void ind() throws IOException {
        String s = "";
        for (int i=0; i<indent; i++) s += "  ";
        write(s);
        lw = false;
    }
    
    public void symbol(Lexan.LexSymbol symb) throws IOException, Exception {
        String s = "ERROR";
        boolean nl = false;
        
        switch (symb) {
            case symbBracOp:    s = "(";    break; // (
            case symbBracCl:    s = ")";    break; // )
            case symbComma:     s = ", ";   break; // ,
            case symbColon:     s = ": ";   break; // :
            case symbVarAss:    s = ":= ";  break; // :=
            case symbSigAss:    s = " <= "; break; // <=
            case symbChoice:    s = " => "; break; // =>
            case symbSemicolon: s = ";";    nl = true; break; // ;
            case symbDot:       s = ".";    break; // .
            default: 
                throw new UnsupportedOperationException("Symbol neni podporovan: " + symb);
        }
        
        write(s);
        if (nl) newLine();
        
        lw = false;
    }
    
    public void opWord(String name) throws IOException {
        write(" <b>" + name + "</b> ");
        lw = false;
    }
    
    public void opSymb(String name) throws IOException {
        write(" " + name + " ");
        lw = false;
    }    
    
    public void writeNewIdent(String name, String addr) throws IOException {
        space();
        write("<a name=\"" + addr + "\"></a>" + name);
        lw = true;
    }
    
    public void writeUseIdent(String name, String addr) throws IOException {
        space();
        write("<a href=\"#" + addr + "\">" + name + "</a>");
        lw = true;
    }
    
    public void comment(String text) throws IOException {
        space();
        write("--" + text);
        br.newLine();
    }
     
    public void writeKw(String name) throws IOException {
        space();
        write("<b>" + name.toLowerCase() + "</b>");
        lw = true;
    }
    
    public void writeType(String name) throws IOException {
        space();
        write("<span id=\"type\">" + name.toLowerCase() + "</span>");
        lw = true;
    }
    
    public void writeInt(String name) throws IOException {
        space();
        write(name);
        lw = true;
    }
    
    public void writeReal(String name) throws IOException {
        space();
        write(name);
        lw = true;
    }
    
    public void writeString(String name) throws IOException {
        space();
        write("<span id=\"string\">"+name+"</span>");
        lw = true;
    }
    
    public void writeBit(String name) throws IOException {
        space();
        write("<span id=\"bit\">'"+name+"'</span>");
        lw = true;
    }
    
    private void write(String name) throws IOException {
        br.write(name);
    }
    
    public void writeAtrib(String name) throws IOException {
        br.write("'" + name + " ");
        lw = true;
    }
    
    public void writeHead(String header) throws IOException {
        br.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
        br.write("<html lang=\"cs\">\n");
        br.write("<head>\n");
        br.write("<meta http-equiv=\"content-type\" content=\"text/html; charset=windows-1250\">\n");
        br.write("<style>");
        br.write("#type {color: orange}");
        br.write("#bit  {color: green}");
        br.write("#string  {color: darkgreen}");
        br.write("#num  {color: green}");
        br.write("body {font-family: Courier New, Verdana, Arial, Courier, sans-serif}");        
        br.write("a:link    {font-weight: bold; text-decoration: none; color: blue}");
        br.write("a:visited    {font-weight: bold; text-decoration: none; color: darkblue}");
        br.write("a:hover    {font-weight: bold; text-decoration: none; color: red}");
        br.write("</style>");
        br.write("<title>" + header + "</title>\n</head>\n<body>\n");
        br.write("<h2>" + header + "</h2>");
    }
    
    public void writeTail() throws IOException {
        br.write("</body>\n</html>");
        br.close();
    }

    void signum(String val) throws IOException {
        write(" " + val + " ");
    }
    
}
