/*
 * Syntax.java
 *
 * Created on 2. leden 2006, 22:17
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.michaltrs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.Exception;
import java.util.ArrayList;
import net.michaltrs.Lexan.LexSymbol;

/**
 *
 * @author Misak
 */
public class Syntax {
    Lexan l;
    OutputHTML out;
    DeclTab dt;
    boolean local = false;

    
    /** Creates a new instance of Syntax */
    public Syntax(String jmeno) {
        try {   
            l = new Lexan(jmeno);
            l.CtiSymbol();
            
            out = new OutputHTML(jmeno + ".html");
            out.writeHead(jmeno);
            
            dt = new DeclTab();
            
            Design_file();
            Srovnani(LexSymbol.symbEOF);
            out.writeTail();
        } catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        } catch (Exception ex) {
            try {
                out.writeTail();
            } catch (IOException e) {
                System.out.println(e.getMessage());
            }
            System.out.println(ex.getMessage());
        }
    }
    
    private void Srovnani(Lexan.LexSymbol ident) throws Exception {
        if (ident == l.symbol) {            
            
            if (ident.toString().contains("symbKw") == true) 
                ident = Lexan.LexSymbol.symbKW;
            
            switch (ident) {
                case symbIDENT: 
                case symbEOF:   break;
                case symbKW:
                    out.writeKw(l.symbVal);
                    break;   
                case symbSTRINGorVECTOR:
                    out.writeString(l.symbVal);
                    break;
                case symbATRIB:
                    out.writeAtrib(l.symbVal);
                    break;
                case symbINT:
                    out.writeInt(l.symbVal);
                    break;
                case symbBIT:
                    out.writeBit(l.symbVal);
                    break;
                case symbREAL:
                    out.writeReal(l.symbVal);
                    break;                    
                case symbSign:
                    out.signum(l.symbVal);
                    break;                
                case symbOpAnd:     // &
                case symbOpRel:     // = | /= | < | > | >=    
                    out.opSymb(l.symbVal);
                    break;
                case symbOpMult:    // * | / | mod | rem  
                case symbOpLog:     // and | or | xor | xnor
                case symbOpLogSpec: // nand | nor 
                case symbOpShift:   // sll | srl | sla | sra | rol | ror
                    out.opWord(l.symbVal);
                    break;                    
                case symbDataType:
                    out.writeType(l.symbVal);
                    break;
                default: 
                    out.symbol(ident);
            }
            
            l.CtiSymbol();
            
            if (l.symbol == LexSymbol.err)
                throw new Exception("Chyba v lexikalni analyze");
        } else {
            throw new Exception("Ocekavan: " + ident + ", nalezen: " + l.symbol + " (" + l.symbVal + ")");
        }
    }
    

    
    private void Declare (boolean declare) throws Exception {
        if (declare) 
            out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        else
            out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
    }
    
    private void Adding_operator () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbSign)
            Srovnani(Lexan.LexSymbol.symbSign);
        else
            Srovnani(Lexan.LexSymbol.symbOpAnd);
    }
    
    private void Architecture_body () throws Exception {
        out.newLine();
        out.newLine();
        Srovnani(Lexan.LexSymbol.symbKwArch);
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        
        Srovnani(Lexan.LexSymbol.symbKwOf);
        out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        
        Srovnani(Lexan.LexSymbol.symbKwIs);
        
        out.shRight();
        Declaration_part();
        out.shLeft();
        
        
        Srovnani(Lexan.LexSymbol.symbKwBegin);	
        local = true;
        
        out.shRight();
        Architecture_statement_part();
        out.shLeft();
        
        
        Srovnani(Lexan.LexSymbol.symbKwEnd);
        if (l.symbol == Lexan.LexSymbol.symbKwArch) {
            
            Srovnani(Lexan.LexSymbol.symbKwArch); 
        }
        if (l.symbol == Lexan.LexSymbol.symbIDENT) {
            out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
            Srovnani(Lexan.LexSymbol.symbIDENT); 
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
        
    }
    
    private void Architecture_statement_part () throws Exception {
        while (l.symbol == Lexan.LexSymbol.symbIDENT ||
               l.symbol == Lexan.LexSymbol.symbKwProc ||            
               l.symbol == Lexan.LexSymbol.symbKwAssert ||
               l.symbol == Lexan.LexSymbol.symbKwGen) {
            dt.newLocal();
            Concurrent_statement();
        }
    }
    
    private void Assertion_statement () throws Exception {            
        Srovnani(Lexan.LexSymbol.symbKwAssert);
        Expression();
        if (l.symbol == Lexan.LexSymbol.symbKwReport) {
            
            Srovnani(Lexan.LexSymbol.symbKwReport);
            Expression();
        }
        if (l.symbol == Lexan.LexSymbol.symbKwSever) {
            
            Srovnani(Lexan.LexSymbol.symbKwSever);
            Expression();
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
        
    }
    
    private void Attribute_name () throws Exception {
        Srovnani(Lexan.LexSymbol.symbATRIB);
        if (l.symbol == Lexan.LexSymbol.symbBracOp) {
            Srovnani(Lexan.LexSymbol.symbBracOp); 
            Expression(); 
            Srovnani(Lexan.LexSymbol.symbBracCl);
        }
    }
    
    private void Block_declarative_item () throws Exception {
        switch (l.symbol) {
            case symbKwType:    Type_declaration(); break;
            case symbKwSubtype: Subtype_declaration(); break;
            case symbKwConst:   Constant_declaration(); break;
            case symbKwSignal:  Signal_declaration(); break;
            case symbKwVar:     Variable_declaration(); break;
            case symbKwComp:    Component_declaration(); break;
            default:            Use_clause(); 
        }
    }
    
    private void Case_statement () throws Exception {
        out.newLine();
        Srovnani(Lexan.LexSymbol.symbKwCase);
        Expression(); 
        Srovnani(Lexan.LexSymbol.symbKwIs);
        
        out.shRight();
        Case_statement_alternative();
        while (l.symbol != Lexan.LexSymbol.symbKwEnd) 
            Case_statement_alternative();
        out.shLeft();
        
        Srovnani(Lexan.LexSymbol.symbKwEnd); 
        Srovnani(Lexan.LexSymbol.symbKwCase);
        if (l.symbol == Lexan.LexSymbol.symbIDENT) {
            out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
            Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Case_statement_alternative () throws Exception {
        out.newLine();        
        Srovnani(Lexan.LexSymbol.symbKwWhen);
        Choice(); 
        Srovnani(Lexan.LexSymbol.symbChoice);	
        Sequence_of_statements();
    }
    
    private void Component_declaration () throws Exception {
        out.newLine();
        Srovnani(Lexan.LexSymbol.symbKwComp);
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        if (l.symbol == Lexan.LexSymbol.symbKwIs) {
            Srovnani(Lexan.LexSymbol.symbKwIs);
        }

        out.shRight();
        if (l.symbol == Lexan.LexSymbol.symbKwGenic)
            Generic_clause();
        if (l.symbol == Lexan.LexSymbol.symbKwPort)
            Port_clause();
        out.shRight();
        
        Srovnani(Lexan.LexSymbol.symbKwEnd);
        Srovnani(Lexan.LexSymbol.symbKwComp);
        if (l.symbol == Lexan.LexSymbol.symbIDENT) {
            out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
            Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);    
        
    }
    
    private void Concurrent_statement () throws Exception {
        switch (l.symbol){
            case symbKwProc:    Process_statement(); break;
            case symbKwAssert:  Assertion_statement(); break;
            default:            Concurrent_statement2();
        }
    }
    
    private void Concurrent_statement2 () throws Exception {
        String ident = l.symbVal;
                
        Srovnani(Lexan.LexSymbol.symbIDENT);
        if (l.symbol == Lexan.LexSymbol.symbColon) {
            out.newLine();
            out.writeNewIdent(ident,dt.addIdent(ident,local));
            Srovnani(Lexan.LexSymbol.symbColon);   
            Concurrent_statement3();
        } else {
            out.writeUseIdent(ident,dt.addIdent(ident,local));
            Concurrent_statement4();
        }
    }
    
    private void Concurrent_statement3 () throws Exception {
        switch (l.symbol) {
            case symbKwProc:    Process_statement(); break;
            case symbKwAssert:  Assertion_statement(); break;
            default:            Generate_statement();
        }
    }
    
    private void Concurrent_statement4 () throws Exception {
        Name3();
        Signal_assignment_statement();
    }
    
    private void Constant_declaration () throws Exception {
        
        Srovnani(Lexan.LexSymbol.symbKwConst);
        Name_list(true);
        Srovnani(Lexan.LexSymbol.symbColon); 
        Name(true);
        if (l.symbol == Lexan.LexSymbol.symbVarAss) {
            
            Srovnani(Lexan.LexSymbol.symbVarAss);
            Expression();
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
        
    }
    
    private void Context_item () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwLib)
            Library_clause();
        else 
           Use_clause(); 
    }
    
    private void Declaration_part () throws Exception {
        while (l.symbol == Lexan.LexSymbol.symbKwType ||        
                l.symbol == Lexan.LexSymbol.symbKwSubtype ||
                l.symbol == Lexan.LexSymbol.symbKwConst ||
                l.symbol == Lexan.LexSymbol.symbKwSignal ||
                l.symbol == Lexan.LexSymbol.symbKwVar ||
                l.symbol == Lexan.LexSymbol.symbKwComp ||
                l.symbol == Lexan.LexSymbol.symbKwUse) {
            Block_declarative_item();
        }
    }

    private void Design_file () throws Exception {
        Design_unit();
        while ((l.symbol == Lexan.LexSymbol.symbKwLib) || (l.symbol == Lexan.LexSymbol.symbKwUse) ||
               (l.symbol == Lexan.LexSymbol.symbKwEnt) || (l.symbol == Lexan.LexSymbol.symbKwArch)) 
            Design_unit();
    }
    
    private void Design_unit () throws Exception {
        while ((l.symbol == Lexan.LexSymbol.symbKwLib) || (l.symbol == Lexan.LexSymbol.symbKwUse))
            Context_item();
        Library_unit();
    }
    
    private void Element_association() throws Exception {
        
        Srovnani(Lexan.LexSymbol.symbKwOth);
        Srovnani(Lexan.LexSymbol.symbChoice);
        Expression();
    }

    
    private void Entity_declaration () throws Exception {
        out.newLine();
        out.newLine();
        Srovnani(Lexan.LexSymbol.symbKwEnt);
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        Srovnani(Lexan.LexSymbol.symbKwIs);

        out.shRight();
        Entity_header();
        Declaration_part();
        if (l.symbol == Lexan.LexSymbol.symbKwBegin) {
            
            Srovnani(Lexan.LexSymbol.symbKwBegin);
            Entity_statement_part();
        }
        out.shLeft();
        
        Srovnani(Lexan.LexSymbol.symbKwEnd);
        if (l.symbol == Lexan.LexSymbol.symbKwEnt) {
            Srovnani(Lexan.LexSymbol.symbKwEnt);
        }
        if (l.symbol == Lexan.LexSymbol.symbIDENT) {
            out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
            Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
        out.newLine();
    }
        
    private void Entity_header () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwGenic)
            Generic_clause();
        if (l.symbol == Lexan.LexSymbol.symbKwPort)
            Port_clause();
    }
    
    private void Entity_statement () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwAssert)
            Assertion_statement();
        else
            Process_statement();
    }
    
    private void Entity_statement_part () throws Exception {
        while (l.symbol == Lexan.LexSymbol.symbKwAssert || 
                l.symbol == Lexan.LexSymbol.symbKwProc || 
                l.symbol == Lexan.LexSymbol.symbKwPost) {
            Entity_statement();
        }
    }
    
    private void Enumeration_type_definition () throws Exception {
        Srovnani(Lexan.LexSymbol.symbBracOp);
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        while (l.symbol == Lexan.LexSymbol.symbComma) {
            Srovnani(Lexan.LexSymbol.symbComma);
            out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
            Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        Srovnani(Lexan.LexSymbol.symbBracCl);
    }
    
    private void Expression () throws Exception {
        Relation(); 
        if (l.symbol == Lexan.LexSymbol.symbOpLogSpec) {
            Srovnani(Lexan.LexSymbol.symbOpLogSpec);
            Relation();
        }
        else
            while (l.symbol == Lexan.LexSymbol.symbOpLog) {
                Srovnani(Lexan.LexSymbol.symbOpLog);
                Relation();
            }
    }
    
    private void Factor () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwAbsNot) {            
            Srovnani(Lexan.LexSymbol.symbKwAbsNot);
        }
        Primary();
    }
    
    private void Generate_statement () throws Exception {
        Generation_scheme();
        Srovnani(Lexan.LexSymbol.symbKwGen);	
        if (l.symbol == Lexan.LexSymbol.symbKwType ||        
                l.symbol == Lexan.LexSymbol.symbKwSubtype ||
                l.symbol == Lexan.LexSymbol.symbKwConst ||
                l.symbol == Lexan.LexSymbol.symbKwSignal ||
                l.symbol == Lexan.LexSymbol.symbKwVar ||
                l.symbol == Lexan.LexSymbol.symbKwComp ||
                l.symbol == Lexan.LexSymbol.symbKwUse) {
            Declaration_part();
            out.newLine();
            Srovnani(Lexan.LexSymbol.symbKwBegin);
        }
        
        out.shRight();
        while (l.symbol != Lexan.LexSymbol.symbKwEnd)
            Concurrent_statement();
        out.shLeft();
        
    	Srovnani(Lexan.LexSymbol.symbKwEnd);
        Srovnani(Lexan.LexSymbol.symbKwGen);
        if (l.symbol == Lexan.LexSymbol.symbIDENT) {
            out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
            Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Generation_scheme () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwFor) {
            Srovnani(Lexan.LexSymbol.symbKwFor); 
            Parameter_specification();
        } else {
            Srovnani(Lexan.LexSymbol.symbKwIf); 
            Expression();
        }
    }
    
    private void Generic_clause () throws Exception {
        Srovnani(Lexan.LexSymbol.symbKwGenic);
        Srovnani(Lexan.LexSymbol.symbBracOp);
        
        out.shRight();
        Interface_list(); 
        out.shLeft();
        
        Srovnani(Lexan.LexSymbol.symbBracCl);
        Srovnani(Lexan.LexSymbol.symbSemicolon);        
    }
    
    private void Choice () throws Exception {
        switch (l.symbol) {
            case symbIDENT:
                out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
                Srovnani(Lexan.LexSymbol.symbIDENT); 
                break;
            case symbSTRINGorVECTOR:    
                Srovnani(Lexan.LexSymbol.symbSTRINGorVECTOR);
                break;
            default:            
                Srovnani(Lexan.LexSymbol.symbKwOth); 
                break;
        }
    }
    
    private void Identifier_list () throws Exception {
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        while (l.symbol == Lexan.LexSymbol.symbComma) {
            out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
            Srovnani(Lexan.LexSymbol.symbIDENT);
        }
    }
    
    private void If_statement () throws Exception {
        Srovnani(Lexan.LexSymbol.symbKwIf);
        Expression();
        Srovnani(Lexan.LexSymbol.symbKwThen);
        Sequence_of_statements();
        while (l.symbol == Lexan.LexSymbol.symbKwElsif) {
            Srovnani(Lexan.LexSymbol.symbKwElsif);
            Expression();
            Srovnani(Lexan.LexSymbol.symbKwThen);
            Sequence_of_statements();
        }	
        if (l.symbol == Lexan.LexSymbol.symbKwElse) {
            Srovnani(Lexan.LexSymbol.symbKwElse);
            Sequence_of_statements();
        }
        Srovnani(Lexan.LexSymbol.symbKwEnd);
        Srovnani(Lexan.LexSymbol.symbKwIf);
        if (l.symbol == Lexan.LexSymbol.symbIDENT) {
            out.writeUseIdent(l.symbVal,dt.getIdent(l.symbVal));
            Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Interface_declaration () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwConst ||
                l.symbol == Lexan.LexSymbol.symbKwSignal ||
                l.symbol == Lexan.LexSymbol.symbKwVar) {
            if (l.symbol == Lexan.LexSymbol.symbKwConst)
                Srovnani(Lexan.LexSymbol.symbKwConst);
            if (l.symbol == Lexan.LexSymbol.symbKwSignal)
                Srovnani(Lexan.LexSymbol.symbKwSignal);
            if (l.symbol == Lexan.LexSymbol.symbKwVar) 
                Srovnani(Lexan.LexSymbol.symbKwVar);        
        }            
        Identifier_list(); 
        Srovnani(Lexan.LexSymbol.symbColon);
        if (l.symbol == Lexan.LexSymbol.symbKwIn || l.symbol == Lexan.LexSymbol.symbKwMode)
            Mode();
        Name(true);
        if (l.symbol == Lexan.LexSymbol.symbKwBus)
            Srovnani(Lexan.LexSymbol.symbKwBus);
        if (l.symbol == Lexan.LexSymbol.symbVarAss) {
            Srovnani(Lexan.LexSymbol.symbVarAss);
            Expression();
        }
    }
    
    private void Interface_list () throws Exception {
        Interface_declaration();
        while (l.symbol == Lexan.LexSymbol.symbSemicolon) {
            Srovnani(Lexan.LexSymbol.symbSemicolon);
            Interface_declaration();
        }

    }
    
    private void Library_clause () throws Exception {
        out.newLine();
        Srovnani(Lexan.LexSymbol.symbKwLib);
        Name_list(true);
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Library_unit () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwEnt)
            Entity_declaration();
        else Architecture_body();
    }
    
    private void Literal () throws Exception {
        switch (l.symbol) {
            case symbINT:               Srovnani(Lexan.LexSymbol.symbINT); break;
            case symbREAL:              Srovnani(Lexan.LexSymbol.symbREAL); break;
            case symbSTRINGorVECTOR:    Srovnani(Lexan.LexSymbol.symbSTRINGorVECTOR); break;
            case symbBIT:               Srovnani(Lexan.LexSymbol.symbBIT); break;
            default:                    Srovnani(Lexan.LexSymbol.symbKwNull); break;
        }
    }
    
    private void Mode () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwIn)
            Srovnani(Lexan.LexSymbol.symbKwIn);
        else
            Srovnani(Lexan.LexSymbol.symbKwMode);
    }
    
    private void Name (boolean declare) throws Exception {
        switch (l.symbol) {
            case symbSTRINGorVECTOR:    Srovnani(Lexan.LexSymbol.symbSTRINGorVECTOR); break;
            case symbVECTOR:            Srovnani(Lexan.LexSymbol.symbVECTOR); break;
            case symbDataType:          
                Srovnani(Lexan.LexSymbol.symbDataType); 
                Name3();
                break;
            default:                    Name2(declare);  break;                 
        }
    }
    
    private void Name2 (boolean declare) throws Exception {
        Declare(declare);
        Srovnani(Lexan.LexSymbol.symbIDENT);
        Name3();
    }
    
    private void Name3 () throws Exception {
        switch (l.symbol) {
            case symbATRIB:     Attribute_name(); break;
            case symbDot:       Selected_name(); break;
            case symbBracOp:    Slice_name(); break;
        }
    }
    
    private void Name_list (boolean declare) throws Exception {
        Declare(declare);
        Srovnani(Lexan.LexSymbol.symbIDENT);
        
        while (l.symbol == Lexan.LexSymbol.symbComma) {
            Srovnani(Lexan.LexSymbol.symbComma);
            Declare(declare);
            Srovnani(Lexan.LexSymbol.symbIDENT);
        }
    }
    
    private void Null_statement () throws Exception {
        Srovnani(Lexan.LexSymbol.symbKwNull);
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Parameter_specification () throws Exception {
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        Srovnani(Lexan.LexSymbol.symbKwIn);
        Range();
    }
    
    private void Port_clause () throws Exception {
        Srovnani(Lexan.LexSymbol.symbKwPort);
        Srovnani(Lexan.LexSymbol.symbBracOp);
        
        out.shRight();
        Interface_list(); 
        out.shLeft();
        
        Srovnani(Lexan.LexSymbol.symbBracCl);
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Prefix () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwAll)
            Srovnani(Lexan.LexSymbol.symbKwAll);
        else {
            out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
            Srovnani(Lexan.LexSymbol.symbIDENT);
            Srovnani(Lexan.LexSymbol.symbDot);
            Prefix();
        }
    }
    
    private void Primary () throws Exception {
        switch (l.symbol) {
            case symbBracOp:    
                Srovnani(Lexan.LexSymbol.symbBracOp);
                Expression();
                Srovnani(Lexan.LexSymbol.symbBracCl);
                break;
            case symbINT:
            case symbREAL:
            case symbSTRINGorVECTOR:
            case symbBIT:
            case symbKwNull:
                Literal();
                break;
            case symbKwOth:
                Element_association();
                break;
            default: 
                Name(false);
        }
    }
    
    private void Process_declarative_item () throws Exception {
        switch (l.symbol) {
            case symbKwType:    Type_declaration(); break;
            case symbKwSubtype: Subtype_declaration(); break;
            case symbKwConst:   Constant_declaration(); break;
            case symbKwVar:     Variable_declaration(); break;
            default:            Use_clause();
        }
    }
    
    private void Process_declarative_part () throws Exception {
        while ((l.symbol == Lexan.LexSymbol.symbKwType) ||
               (l.symbol == Lexan.LexSymbol.symbKwSubtype) ||
               (l.symbol == Lexan.LexSymbol.symbKwConst) ||
               (l.symbol == Lexan.LexSymbol.symbKwVar) ||
               (l.symbol == Lexan.LexSymbol.symbKwUse)) {
            Process_declarative_item();
        }
    }
    
    private void Process_statement () throws Exception {
        out.newLine();
        if (l.symbol == Lexan.LexSymbol.symbKwPost)
            Srovnani(Lexan.LexSymbol.symbKwPost);
        Srovnani(Lexan.LexSymbol.symbKwProc);
        if (l.symbol == Lexan.LexSymbol.symbBracOp) {
            Srovnani(Lexan.LexSymbol.symbBracOp);
            Name_list(false);
            Srovnani(Lexan.LexSymbol.symbBracCl);
        }
        if (l.symbol == Lexan.LexSymbol.symbKwIs)
            Srovnani(Lexan.LexSymbol.symbKwIs);
        
        out.shRight();
        Process_declarative_part();
        out.shLeft();
        
        Srovnani(Lexan.LexSymbol.symbKwBegin);
        Sequence_of_statements();
        Srovnani(Lexan.LexSymbol.symbKwEnd);
        if (l.symbol == Lexan.LexSymbol.symbKwPost)
            Srovnani(Lexan.LexSymbol.symbKwPost);
        Srovnani(Lexan.LexSymbol.symbKwProc);
        if (l.symbol == Lexan.LexSymbol.symbIDENT)
            Srovnani(Lexan.LexSymbol.symbIDENT);
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Range () throws Exception {
        Simple_expression();
        if (l.symbol == Lexan.LexSymbol.symbKwDir) {
            Srovnani(Lexan.LexSymbol.symbKwDir);
            Simple_expression();
        }
    }
    
    private void Relation () throws Exception {
        Shift_expression();	 
        if ((l.symbol == Lexan.LexSymbol.symbOpRel) || (l.symbol == Lexan.LexSymbol.symbSigAss)) {
            Relational_operator();
            Shift_expression();
        }
    }
    
    private void Relational_operator () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbOpRel) {
            Srovnani(Lexan.LexSymbol.symbOpRel);
        } else
            Srovnani(Lexan.LexSymbol.symbSigAss);
    }
        
    private void Selected_name () throws Exception {
        Srovnani(Lexan.LexSymbol.symbDot);
        Prefix();
    }
    
    private void Sequence_of_statements () throws Exception {
        while (l.symbol == Lexan.LexSymbol.symbKwWait ||
                l.symbol == Lexan.LexSymbol.symbKwAssert ||
                l.symbol == Lexan.LexSymbol.symbKwIf ||
                l.symbol == Lexan.LexSymbol.symbKwCase ||
                l.symbol == Lexan.LexSymbol.symbKwNull ||
                l.symbol == Lexan.LexSymbol.symbIDENT) {
            out.shRight();
            Sequential_statement();
            out.shLeft();
            
        }
    }
    
    private void Sequential_statement () throws Exception {
        switch (l.symbol) {
            case symbKwWait:    Wait_statement(); break;
            case symbKwAssert:  Assertion_statement(); break;
            case symbKwIf:      If_statement(); break;
            case symbKwCase:    Case_statement(); break;
            case symbKwNull:    Null_statement(); break;
            default:            Sequential_statement2();
        }
    }
    
    private void Sequential_statement2 () throws Exception {
        String ident = l.symbVal;
        
        Srovnani(Lexan.LexSymbol.symbIDENT);
        if (l.symbol == Lexan.LexSymbol.symbColon) {
            Srovnani(Lexan.LexSymbol.symbColon);
            out.writeNewIdent(ident,dt.addIdent(ident,local));
            Sequential_statement3();
        } else {
            out.writeUseIdent(ident,dt.getIdent(ident));
            Sequential_statement4();
        }
    }
    
    private void Sequential_statement3 () throws Exception {
        switch (l.symbol) {
            case symbKwWait:    Wait_statement(); break;
            case symbKwAssert:  Assertion_statement(); break;
            case symbKwIf:      If_statement(); break;
            case symbKwCase:    Case_statement(); break;
            default:            Null_statement();
        }
    }
    
    private void Sequential_statement4 () throws Exception {
        Name3();
        if (l.symbol == Lexan.LexSymbol.symbVarAss)
            Variable_assignment_statement();
        else
            Signal_assignment_statement();
    }
    
    
    
    private void Shift_expression () throws Exception {
        Simple_expression();
        if (l.symbol == Lexan.LexSymbol.symbOpShift) {
            Srovnani(Lexan.LexSymbol.symbOpShift);
            Simple_expression();
        }
    }
    
    private void Signal_assignment_statement () throws Exception {
        Srovnani(Lexan.LexSymbol.symbSigAss);
        Waveform();
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Signal_declaration () throws Exception {
        Srovnani(Lexan.LexSymbol.symbKwSignal);
        Name_list(true);
        Srovnani(Lexan.LexSymbol.symbColon);
        Name(false);
        if ((l.symbol == Lexan.LexSymbol.symbKwReg) || (l.symbol == Lexan.LexSymbol.symbKwBus)) {
            if (l.symbol == Lexan.LexSymbol.symbKwReg)
                Srovnani(Lexan.LexSymbol.symbKwReg);
            else
                Srovnani(Lexan.LexSymbol.symbKwBus);
        }
        if (l.symbol == Lexan.LexSymbol.symbVarAss) {
            Srovnani(Lexan.LexSymbol.symbVarAss);
            Expression();
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Simple_expression () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbSign) {
            Srovnani(Lexan.LexSymbol.symbSign);
        }
        Term();
        while (l.symbol == Lexan.LexSymbol.symbSign || l.symbol == Lexan.LexSymbol.symbOpAnd) {
            Adding_operator();
            Term();
        }
    }
    
    private void Slice_name () throws Exception {
        Srovnani(Lexan.LexSymbol.symbBracOp);
        Range();
        Srovnani(Lexan.LexSymbol.symbBracCl);
    }
    
    private void Subtype_declaration () throws Exception {
        Srovnani(Lexan.LexSymbol.symbKwSubtype);
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        Srovnani(Lexan.LexSymbol.symbKwIs);
        Name(false);
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Term () throws Exception {
        Factor();
        while(l.symbol == Lexan.LexSymbol.symbOpMult) { 
            Srovnani(Lexan.LexSymbol.symbOpMult);
            Factor();
        }
    }
    
    private void Type_declaration () throws Exception {
        out.newLine();
        Srovnani(Lexan.LexSymbol.symbKwType);
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        if (l.symbol == Lexan.LexSymbol.symbKwIs) {
            Srovnani(Lexan.LexSymbol.symbKwIs);
            Enumeration_type_definition();
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Use_clause () throws Exception {
        Srovnani(Lexan.LexSymbol.symbKwUse);
        out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
        Srovnani(Lexan.LexSymbol.symbIDENT);
        Selected_name();
        while (l.symbol == Lexan.LexSymbol.symbComma) { 
            Srovnani(Lexan.LexSymbol.symbComma);
            out.writeNewIdent(l.symbVal,dt.addIdent(l.symbVal,local));
            Srovnani(Lexan.LexSymbol.symbIDENT);
            Selected_name(); 
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Variable_assignment_statement () throws Exception {
        Srovnani(Lexan.LexSymbol.symbVarAss);
        Expression();
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Variable_declaration () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwShared)
            Srovnani(Lexan.LexSymbol.symbKwShared);
        Srovnani(Lexan.LexSymbol.symbKwVar);
        Name_list(true);
        Srovnani(Lexan.LexSymbol.symbColon);
        Name(true);
        if (l.symbol == Lexan.LexSymbol.symbVarAss) {
            Srovnani(Lexan.LexSymbol.symbVarAss);
            Expression(); 
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Wait_statement () throws Exception {
        out.newLine();
        Srovnani(Lexan.LexSymbol.symbKwWait);
        if (l.symbol == Lexan.LexSymbol.symbKwOn) {
            Srovnani(Lexan.LexSymbol.symbKwOn);
            Name_list(false);
        }
        if (l.symbol == Lexan.LexSymbol.symbKwUntil){
            Srovnani(Lexan.LexSymbol.symbKwUntil); 
            Expression();            
        }
        if (l.symbol == Lexan.LexSymbol.symbKwFor){
            Srovnani(Lexan.LexSymbol.symbKwFor); 
            Expression();            
        }
        Srovnani(Lexan.LexSymbol.symbSemicolon);
    }
    
    private void Waveform () throws Exception {
        if (l.symbol == Lexan.LexSymbol.symbKwNull) {
            Srovnani(Lexan.LexSymbol.symbKwNull);
            if (l.symbol == Lexan.LexSymbol.symbKwAfter) {
                Srovnani(Lexan.LexSymbol.symbKwAfter);
                Expression();
            }
        } else {
            Expression();
            if (l.symbol == Lexan.LexSymbol.symbKwAfter) {
                Srovnani(Lexan.LexSymbol.symbKwAfter);
                Expression();
            }    
        }
    }


    
}
