/*
  Name: data.c
  Copyright: 
  Author: Michal Trs
  Date: May 2005
  Description: most strings for EXIF reader
*/


#include "data.h"


/* data declaration */



tItem ErrArr[] ={{0,""}, /* OK */
                 {1,"Can't open file"},
                 {2,"Can't read the file!"},
                 {3,"File hasn't JPEG format!"},
                 {4,"EXIF information isn't aviable!"},
                 {5,"Error in file!"},
                 {7,"Unexpected end of file"},
                 {10,"Can't close file"},
                 {15,"unknown parametr. type -h for help"},
                 {255,"Unknown error"} /* zarazka */
                 };


tItem IFD0[] = { {0x0100,"Image width"}, 
                 {0x0101,"Image height"},
                 {0x0102,"Bits per component"},    
                 {0x0103,"Compression scheme"},
                 {0x0106,"Pixel composition"},
                 {0x010e,"Image title"},
                 {0x010f,"Make"},
                 {0x0110,"Model"},
                 {0x0111,"Image data location"},
                 {0x0112,"Orientation"}, 
                 {0x0115,"Number of components"},
                 {0x0116,"Number of rows per strip"},
                 {0x0117,"Bytes per compressed strip"},
                 {0x011a,"XResolution"},
                 {0x011b,"YResolution"},
                 {0x011c,"Image data arrangement"},
                 {0x0128,"Resolution Unit"}, 
                 {0x012D,"Transfer function"},
                 {0x0131,"Firmware version"},
                 {0x0132,"Date and Time"},
                 {0x013b,"Artist"},                 
                 {0x013e,"WhitePoint"},
                 {0x013f,"Primary Chromaticities"},
                 {0x0201,"Offset to JPEG SOI"},                 
                 {0x0202,"Bytes of JPEG data"},                 
                 {0x0211,"YCbCr Coefficients"},
                 {0x0212,"Subsampling ratio of Y to C"},                                  
                 {0x0213,"YCbCr Positioning"},
                 {0x0214,"Reference BlackWhite"},
                 {0x8298,"Copyright"},
                 {0x8769,"---Exif offset---"},
                 {0x8825,"---GPS offset ---"},                 
                 {0x0FF,"-----zarazka1-----"}
               }; 
                              

tItem IFDex[]= { {0x829A,"Exposure Time"},   
                 {0x829D,"F Number"},
                 {0x8822,"Exposure Program"},
                 {0x8824,"Spectral sensitivity"},
                 {0x8827,"ISO Speed Ratings"},
                 {0x8828,"Optoelectric coefficient"},
                 {0x9000,"Exif Version"},  
                 {0x9003,"Date/Time of original"},
                 {0x9004,"Date/Time of digitized"},
                 {0x9101,"Component Configuration"},
                 {0x9102,"Compression ratio"},
                 {0x9201,"Shutter Speed"}, 
                 {0x9202,"Aperture value"},
                 {0x9203,"Brightness"},     
                 {0x9204,"Exposure Bias"},
                 {0x9205,"Max aperture value"},
                 {0x9206,"Subject distance"},
                 {0x9207,"Metering mode"},
                 {0x9208,"Light Source"}, 
                 {0x9209,"Flash"},        
                 {0x920A,"Focal length"}, 
                 {0x9214,"Subject area"},
                 {0x927C,"---Maker Note---"},  
                 {0x9286,"User comment"},
                 {0x9290,"DateTime subseconds"},
                 {0x9291,"DateTimeOriginal subseconds"},
                 {0x9292,"DateTimeDigitized subseconds"},
                 {0xa000,"Flash Pix Version"},
                 {0xa001,"Color space"},
                 {0xa002,"Width of main image"},
                 {0xa003,"Height of main image"},
                 {0xa004,"Related sound file"},
                 {0xa005,"Exif Interoperability Offset"},
                 {0xa20b,"Flash energy"},
                 {0xa20c,"Spatial frequency response"},
                 {0xa20e,"Focal plane XResolution"},
                 {0xa20f,"Focal plane YResolution"},
                 {0xa210,"Focal plane Resolution unit"},
                 {0xa214,"Subject location"},
                 {0xa215,"Exposure index"},
                 {0xa217,"Sensing method "}, 
                 {0xa300,"File source"},
                 {0xa301,"Scene type"},
                 {0xa302,"CFA pattern"},
                 {0xa401,"Image processing"},
                 {0xa402,"Exposure mode"},
                 {0xa403,"White balance"},
                 {0xa404,"Digital zoom ratio"},
                 {0xa405,"Focal length in 35 mm film"},
                 {0xa406,"Scene capture type"},
                 {0xa407,"Gain control"},
                 {0xa408,"Contrast"},
                 {0xa409,"Saturation"},
                 {0xa40a,"Sharpness"},
                 {0xa40b,"Device settings description"},
                 {0xa40c,"Subject distance range"},
                 {0xa420,"Unique image ID"},
                 {0x0FF,"-----zarazka2-----"}
                 };  

                 
int dataPcom[] = {1,1,2,4,8,1,1,2,4,8,4,8};



tSpecItem spec[] = { {0x0112, { {1,"upper left"},
                                {3,"lower right"},
                                {6,"upper right"},
                                {8,"lower left"},
                                {9,"undefined"},
                                {0x0FF,"-----zarazka-----"}                                   
                              } },
                     {0x0128, { {1,"no-unit"},
                                {2,"inch"},
                                {3,"centimeter"},
                                {0x0FF,"-----zarazka-----"}
                              } },
                     {0x0213, { {1,"centered"},
                                {2,"co-sited"},
                                {0x0FF,"-----zarazka-----"}
                              } },
                     {0x8822, { {1,"manual control"},
                                {2,"normal"},
                                {3,"aperture priority"},
                                {4,"shutter priority"},
                                {5,"creative (slow program)"},
                                {6,"action (high-speed program)"},
                                {7,"portrait"},
                                {8,"landscape"},
                                {0x0FF,"-----zarazka-----"}
                              } },   
                     {0x9207, { {1,"average"},
                                {2,"center weighted average"},
                                {3,"spot"},
                                {4,"multi-spot"},
                                {5,"pattern"},
                                {6,"partial"},
                                {0x0FF,"-----zarazka-----"}
                              } },                                                                                                 
                     {0x9208, { {0,"auto"},
                                {1,"daylight"},
                                {2,"fluorescent"},
                                {3,"tungsten"},
                                {10,"flash"},
                                {0x0FF,"-----zarazka-----"}
                              } },                        
                     {0xA001, { {1,"sRGB"},
                                {0xFFFF,"Uncalibrated"},
                                {0x0FF,"-----zarazka-----"}
                              } },  
                     {0xA210, { {1,"no-unit"},
                                {2,"inch"},
                                {3,"centimeter"},
                                {0x0FF,"-----zarazka-----"}
                              } },                      
                     {0xA217, { {2,"One-chip color area sensor"},
                                {3,"Two-chip color area sensor"},
                                {4,"Three-chip color area sensor"},
                                {5,"Color sequential area sensor"},
                                {7,"Trilinear sensor"},
                                {8,"Color sequential linear sensor"},
                                {0x0FF,"-----zarazka-----"}
                              } },                       
                     {0xA301, { {1,"directly photographed image"},
                                {0x0FF,"-----zarazka-----"}
                              } },                        
                     {0xA401, { {0,"normal"},
                                {1,"custom"},
                                {0x0FF,"-----zarazka-----"}
                              } },                   
                     {0xA402, { {0,"auto"},
                                {1,"manual"},
                                {2,"auto bracket"},
                                {0x0FF,"-----zarazka-----"}
                              } },                          
                     {0xA403, { {0,"auto"},
                                {1,"manual"},
                                {0x0FF,"-----zarazka-----"}
                              } },     
                     {0xA406, { {0,"standard"},
                                {1,"landscape"},
                                {2,"portrait"},
                                {3,"night scene"},
                                {0x0FF,"-----zarazka-----"}
                              } },   
                     {0xA407, { {0,"none"},
                                {1,"low gain up"},
                                {2,"high gain up"},
                                {3,"low gain down"},
                                {4,"high gain down"},
                                {0x0FF,"-----zarazka-----"}
                              } },             
                     {0xA408, { {0,"normal"},
                                {1,"soft"}, 
                                {2,"hard"},
                                {0x0FF,"-----zarazka-----"}
                              } },                        
                     {0xA409, { {0,"normal"},
                                {1,"low"},
                                {2,"high"},
                                {0x0FF,"-----zarazka-----"}
                              } },                        
                     {0xA40A, { {0,"normal"},
                                {1,"soft"},
                                {2,"hard"},
                                {0x0FF,"-----zarazka-----"}
                              } },   
                     {0xFF}
                              };
                              
char *help = "\n \
EXIF reader written by Michal Trs\n \
syntax: exifr [-d] file.jpg\n\n \
for show this help run this program without any parameters or type \n \
exifr -h or exifr --help";
           

