/*
  Name: pfunc.c
  Copyright: 
  Author: Michal Trs
  Date: May 2005
  Description: print and decode function
*/

/* implementace print funkci */

#include <stdio.h>
#include <stdlib.h>
#include "data.h"
#include "mem.h"

/* funkce */

/* print byte */
void printBYTE(unsigned char value) {
  printf("%hu",value);     
}

/* print string from memory */
void printASCII(unsigned char *from, unsigned long int adr, unsigned long int len) { 
  unsigned long int i;
  
  for (i = adr; i < (adr+len); i++)
      putchar(from[i]);   
}

/* print short */
void printSHORT(unsigned int value) {
  printf("%hu",value);     
}

/* print long */
void printLONG(unsigned long int value) {
  printf("%lu",value);     
}

/* print slong */
void printSLONG(long int value) {
  printf("%ld",value);     
}


/* komplexnejsi funkce */


int ErrMsg(int errCode) { /* Display error message, using ErrArr, return Error code */
  int i;
  for (i=0; (ErrArr[i].key != 255) && (ErrArr[i].key != errCode); i++ ) {};
  fprintf(stderr,"%s\n",ErrArr[i].TagName); 
  return errCode;
}

int printIFDname(unsigned int tagID, IFDtype typ) {
  tItem *src;
  int i;
  
  switch (typ) {
    case tIFD0: src = IFD0;   break;
    case tIFD1:               break;
    case tEXIF: src = IFDex;  break;
    case tGPS:                break;      
    case tMAKER:              break;
  }

  for (i=0; src[i].key != 0x0FF; i++)
    if (src[i].key == tagID) break;

  if (src[i].key == tagID) 
    printf("%s",src[i].TagName); 
  else 
    return 1;
  
  return 0;       
}

int vtospec(unsigned int value, tItem *src) {  
  int i;  
    
  for (i=0; src[i].key != 0x0FF; i++)
    if (src[i].key == value) break;
    
  if (src[i].key == value) {
    printf("%s",src[i].TagName);
    return 0;
  } else 
    return 1;
}


/* dekodovani hodnot na text */

void p0x9101(unsigned char mem[], unsigned long int index) {
  int i;
  for (i=0; i < 4; i++)
    switch (mem[index+i]) {
      case 1: printf("Y"); break;
      case 2: printf("Cb"); break;
      case 3: printf("Cr"); break;
      case 4: printf("R"); break;
      case 5: printf("G"); break;
      case 6: printf("B"); break;
      default :  break;       
    }
}

void p0x9209(unsigned short int value) {
  if (value & 0x20) {printf("No flash function"); return; }; 
  if (value & 0x01) printf("Flash fired");
    else printf("Flash did not fire");
  switch ((value & 0x06) >> 1) {          
    case 0: break;       
    case 1: break;
    case 2: printf(", return light not detected"); break;
    case 3: printf(", return light detected"); break;            
  }
  switch ((value & 0x18) >> 3) {          
    case 0: break;       
    case 1: printf(", compulsory flash firing"); break;
    case 2: printf(", compulsory flash suppression"); break;
    case 3: printf(", auto mode"); break;            
  }
  if (value & 0x40) printf(", red-eye reduction mode"); 
}

void p0xa000(unsigned char from[], unsigned long int index) {
  if (from[index] == '0' && from[index+1] == '1' && from[index+2] == '0' && from[index+3] == '0') 
    printf("Flashpix Format Version 1.0");  
}


int printSPEC(unsigned int tagID, unsigned short int value) {
  int i;
  
  for (i=0; spec[i].key != 0x0FF; i++) 
    if (spec[i].key == tagID) break;
  
  if (spec[i].key == tagID)
    i = vtospec(value,spec[i].values);
  else return 1;  
  
  if (i) printSHORT(value);     

  return 0;
}

int printIFDvalue(unsigned int tagID, unsigned int df, unsigned long int coc, unsigned long int index, int decode) {
  int res=0;

  if (decode)
   switch (tagID) { 
    case 0x9000: printASCII(mem,index,4); break;
    case 0x9101: p0x9101(mem,index); break; 
    case 0x9209: p0x9209(getSHORT(index)); break;   
    case 0xa000: p0xa000(mem,index); break;    
    default: res = printSPEC(tagID,getSHORT(index)); break;
   }
  else res=1;
            
  if (res)
    switch (df) {
      case  1: printBYTE(getBYTE(index));            break;
      case  2: printASCII(mem,index,coc);            break;       
      case  3: printSHORT(getSHORT(index));          break;
      case  4: printLONG(getLONG(index));            break;
      case  5: printf("%.3f",getRATIONAL(index));    break;
      case  9: printSLONG(getSLONG(index));          break;
      case 10: printf("%.3f",getSRATIONAL(index));   break;                
    }  
  return 0;
} 

void showHelp(void) {
  printf("%s",help);     
}


