/*
 * Decompiled with CFR 0.152.
 */
package net.michaltrs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.michaltrs.DlgText;
import net.michaltrs.PaintBoardWindow_BtnLine_actionAdapter;
import net.michaltrs.PaintBoardWindow_BtnOval_actionAdapter;
import net.michaltrs.PaintBoardWindow_BtnPen_actionAdapter;
import net.michaltrs.PaintBoardWindow_BtnRect_actionAdapter;
import net.michaltrs.PaintBoardWindow_BtnText_actionAdapter;
import net.michaltrs.PaintBoardWindow_component1_mouseAdapter;
import net.michaltrs.PaintBoardWindow_component1_mouseMotionAdapter;
import net.michaltrs.PaintServerInterface;
import net.michaltrs.PaintingComp;
import net.michaltrs.Shape;

public class PaintBoardWindow
extends JFrame
implements Runnable {
    BorderLayout borderLayout1 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();
    PaintingComp component1 = new PaintingComp();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel statusBar = new JLabel();
    JLabel LabelSelect = new JLabel();
    JComboBox ComboBoxColor = new JComboBox();
    TitledBorder titledBorder1 = new TitledBorder("");
    public static final int PEN = 1;
    public static final int LINE = 2;
    public static final int RECT = 3;
    public static final int OVAL = 4;
    public static final int TEXT = 5;
    PaintServerInterface psi = null;
    private int lastX = 0;
    private int lastY = 0;
    private boolean btnDown = false;
    private boolean isRunning = true;
    Thread t = null;
    Date lastUpdate = new Date();
    Map m = new HashMap();
    JButton BtnLine = new JButton();
    JButton BtnRect = new JButton();
    JButton BtnOval = new JButton();
    JButton BtnText = new JButton();
    JButton BtnPen = new JButton();
    TitledBorder titledBorder2 = new TitledBorder("");
    int select = 1;

    public PaintBoardWindow(PaintServerInterface p) {
        try {
            this.jbInit();
            this.fillColors();
            this.psi = p;
            this.t = new Thread(this);
            this.t.start();
            this.component1.setData(this.psi.getBoard());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PaintBoardWindow(String path) {
        try {
            this.jbInit();
            this.fillColors();
            this.psi = (PaintServerInterface)Naming.lookup(path);
            this.t = new Thread(this);
            this.t.start();
            this.component1.setData(this.psi.getBoard());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fillColors() {
        this.m.put("red", Color.RED);
        this.m.put("black", Color.BLACK);
        this.m.put("blue", Color.BLUE);
        this.m.put("yellow", Color.YELLOW);
        this.m.put("cyan", Color.CYAN);
        this.m.put("green", Color.GREEN);
        this.m.put("orange", Color.ORANGE);
        this.m.put("magenta", Color.MAGENTA);
        this.m.put("pink", Color.PINK);
        this.m.put("gray", Color.GRAY);
        Object[] arr = this.m.keySet().toArray();
        Arrays.sort(arr);
        for (int i = 0; i < arr.length; ++i) {
            this.ComboBoxColor.addItem(arr[i]);
        }
    }

    public void run() {
        while (this.isRunning) {
            try {
                if (!this.psi.isUpDate(this.lastUpdate)) continue;
                Shape[] data = this.psi.getBoard();
                System.out.println(data.length);
                this.component1.setData(data);
                this.lastUpdate = new Date();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jbInit() throws Exception {
        this.component1 = new PaintingComp();
        this.getContentPane().setLayout(this.borderLayout1);
        this.component1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.component1.setMinimumSize(new Dimension(320, 240));
        this.component1.setPreferredSize(new Dimension(800, 600));
        this.component1.addMouseMotionListener(new PaintBoardWindow_component1_mouseMotionAdapter(this));
        this.component1.addMouseListener(new PaintBoardWindow_component1_mouseAdapter(this));
        this.statusBar.setText("x: -- y: --");
        this.jPanel2.setLayout(this.gridLayout1);
        this.BtnLine.setBorder(this.titledBorder2);
        this.BtnLine.setToolTipText("");
        this.BtnLine.setText("Line");
        this.BtnLine.addActionListener(new PaintBoardWindow_BtnLine_actionAdapter(this));
        this.BtnRect.setBorder(this.titledBorder2);
        this.BtnRect.setText("Rectangle");
        this.BtnRect.addActionListener(new PaintBoardWindow_BtnRect_actionAdapter(this));
        this.BtnOval.setBorder(this.titledBorder2);
        this.BtnOval.setText("Oval");
        this.BtnOval.addActionListener(new PaintBoardWindow_BtnOval_actionAdapter(this));
        this.BtnText.setBorder(this.titledBorder2);
        this.BtnText.setText("Text");
        this.BtnText.addActionListener(new PaintBoardWindow_BtnText_actionAdapter(this));
        this.LabelSelect.setText("Pen");
        this.jLabel1.setText("Color");
        this.ComboBoxColor.setMinimumSize(new Dimension(70, 21));
        this.ComboBoxColor.setPreferredSize(new Dimension(70, 21));
        this.BtnPen.setBorder(this.titledBorder1);
        this.BtnPen.setText("Pen");
        this.BtnPen.addActionListener(new PaintBoardWindow_BtnPen_actionAdapter(this));
        this.setResizable(false);
        this.jPanel1.add(this.jLabel1);
        this.jPanel1.add(this.ComboBoxColor);
        this.jPanel1.add(this.BtnPen);
        this.jPanel1.add(this.BtnLine);
        this.jPanel1.add(this.BtnRect);
        this.jPanel1.add(this.BtnOval);
        this.jPanel1.add(this.BtnText);
        this.jPanel2.add((Component)this.statusBar, null);
        this.jPanel2.add((Component)this.LabelSelect, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.getContentPane().add((Component)this.component1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "North");
    }

    public void component1_mousePressed(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
        this.btnDown = true;
        switch (this.select) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                DlgText dlg = new DlgText(this, "Type text...", true);
                dlg.show();
                String t = dlg.getText();
                if (t == null) break;
                try {
                    this.psi.paintText(e.getX(), e.getY(), t, (Color)this.m.get(this.ComboBoxColor.getSelectedItem()));
                }
                catch (RemoteException ex) {}
                break;
            }
        }
    }

    public void component1_mouseReleased(MouseEvent e) {
        switch (this.select) {
            case 1: {
                this.btnDown = false;
                break;
            }
            case 2: {
                try {
                    this.psi.paintLine(this.lastX, this.lastY, e.getX(), e.getY(), (Color)this.m.get(this.ComboBoxColor.getSelectedItem()));
                }
                catch (RemoteException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    this.psi.paintRect(this.lastX, this.lastY, e.getX(), e.getY(), (Color)this.m.get(this.ComboBoxColor.getSelectedItem()));
                }
                catch (RemoteException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    this.psi.paintOval(this.lastX, this.lastY, e.getX(), e.getY(), (Color)this.m.get(this.ComboBoxColor.getSelectedItem()));
                }
                catch (RemoteException ex) {
                    ex.printStackTrace();
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void component1_mouseDragged(MouseEvent e) {
        switch (this.select) {
            case 1: {
                if (!this.btnDown) break;
                try {
                    this.psi.paintLine(this.lastX, this.lastY, e.getX(), e.getY(), (Color)this.m.get(this.ComboBoxColor.getSelectedItem()));
                    break;
                }
                catch (RemoteException ex) {
                    ex.printStackTrace();
                    break;
                }
                finally {
                    this.lastX = e.getX();
                    this.lastY = e.getY();
                    this.statusBar.setText("x: " + this.lastX + ", y: " + this.lastY);
                }
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public void BtnPen_actionPerformed(ActionEvent e) {
        this.select = 1;
        this.LabelSelect.setText("Pen");
    }

    public void BtnLine_actionPerformed(ActionEvent e) {
        this.select = 2;
        this.LabelSelect.setText("Line");
    }

    public void BtnRect_actionPerformed(ActionEvent e) {
        this.select = 3;
        this.LabelSelect.setText("Rectangle");
    }

    public void BtnOval_actionPerformed(ActionEvent e) {
        this.select = 4;
        this.LabelSelect.setText("Oval");
    }

    public void BtnText_actionPerformed(ActionEvent e) {
        this.select = 5;
        this.LabelSelect.setText("Text");
    }
}

