package net.michaltrs;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.*;
import java.awt.*;
import com.borland.jbcl.layout.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.Naming;
import java.net.*;
import java.rmi.*;
import java.rmi.registry.Registry;

/**
 * Hlavni frame pro pripojeni k nstenkovemu serveru
 * Umoznuje vybrat nastenku na dannem srveru a pripadne vymazat jeji obsah
 *
 * @author Michal Trs
 */
public class PaintBoardConnectFrame extends JFrame {
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel statusBar = new JLabel();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JList ListBoard = new JList();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    VerticalFlowLayout verticalFlowLayout3 = new VerticalFlowLayout();
    JTextField TextFieldPort = new JTextField();
    JTextField TextFieldServer = new JTextField();
    JButton BtnClear = new JButton();
    JButton BtnConnServer = new JButton();
    JButton BtnCon = new JButton();

    PaintServerInterface psi = null;
    JFrame win = null;

    public PaintBoardConnectFrame() {
        try {
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(borderLayout1);
        this.setDefaultCloseOperation(EXIT_ON_CLOSE);
        setSize(new Dimension(253, 465));
        setTitle("Paint board connection");
        statusBar.setBorder(null);
        statusBar.setText(" ");
        jPanel1.setLayout(verticalFlowLayout1);
        jPanel2.setLayout(verticalFlowLayout3);
        jLabel1.setText("Existing boards:");
        ListBoard.setMinimumSize(new Dimension(100, 100));
        ListBoard.setPreferredSize(new Dimension(240, 200));
        jLabel2.setText("Server name:");
        TextFieldPort.setNextFocusableComponent(BtnConnServer);
        TextFieldPort.setText("1099");
        jLabel3.setText("Port:");
        TextFieldServer.setNextFocusableComponent(TextFieldPort);
        TextFieldServer.setText("localhost");
        jPanel4.setLayout(borderLayout2);
        BtnClear.setText("Clear board");
        BtnClear.addActionListener(new
                PaintBoardConnectFrame_BtnCreate_actionAdapter(this));
        BtnConnServer.setNextFocusableComponent(ListBoard);
        BtnConnServer.setText("Connect server!");
        BtnConnServer.addActionListener(new
                PaintBoardConnectFrame_BtnConnServer_actionAdapter(this));
        BtnCon.setText("Connect!");
        BtnCon.addActionListener(new
                PaintBoardConnectFrame_jButton1_actionAdapter(this));
        jPanel1.add(jLabel1);
        jPanel1.add(ListBoard, null);
        jPanel1.add(jPanel4);
        jPanel4.add(BtnClear, java.awt.BorderLayout.CENTER);
        jPanel4.add(BtnCon, java.awt.BorderLayout.WEST);
        jPanel2.add(jLabel2);
        jPanel2.add(TextFieldServer);
        jPanel2.add(jLabel3);
        jPanel2.add(TextFieldPort);
        jPanel2.add(BtnConnServer);
        contentPane.add(statusBar, java.awt.BorderLayout.SOUTH);
        contentPane.add(jPanel1, java.awt.BorderLayout.CENTER);
        contentPane.add(jPanel2, java.awt.BorderLayout.NORTH);
    }

    public void BtnConnServer_actionPerformed(ActionEvent e) {
        try {
            String srv = TextFieldServer.getText();
            String p  =  TextFieldPort.getText();
            String[] s = Naming.list("//" + srv + ":" + p);
            ListBoard.setListData(s);
            statusBar.setText("OK");
        } catch (Exception ex) {
            String[] err = {"Wrong server name or port number"};
            ListBoard.setListData(err);
            statusBar.setText(err[0]);
        }
    }

    public void BtnCreate_actionPerformed(ActionEvent e) {
        try {
            psi.clearBoard();
            win.repaint();
            win.show();
        } catch (RemoteException ex) {
            statusBar.setText("Can't clear board");
        }
    }

    public void jButton1_actionPerformed(ActionEvent e) {
        try {
            String path = (String) ListBoard.getSelectedValue();
            psi = (PaintServerInterface) Naming.lookup(path);
            win = new PaintBoardWindow(psi);
            //JFrame win = new PaintBoardWindow(path);
            win.pack();
            win.setTitle("Paint board " + path);
            win.setVisible(true);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

}


class PaintBoardConnectFrame_jButton1_actionAdapter implements ActionListener {
    private PaintBoardConnectFrame adaptee;
    PaintBoardConnectFrame_jButton1_actionAdapter(PaintBoardConnectFrame
                                                  adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButton1_actionPerformed(e);
    }
}


class PaintBoardConnectFrame_BtnCreate_actionAdapter implements ActionListener {
    private PaintBoardConnectFrame adaptee;
    PaintBoardConnectFrame_BtnCreate_actionAdapter(PaintBoardConnectFrame
            adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnCreate_actionPerformed(e);
    }
}


class PaintBoardConnectFrame_BtnConnServer_actionAdapter implements
        ActionListener {
    private PaintBoardConnectFrame adaptee;
    PaintBoardConnectFrame_BtnConnServer_actionAdapter(PaintBoardConnectFrame
            adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnConnServer_actionPerformed(e);
    }
}
