package net.michaltrs;

import javax.swing.JFrame;
import javax.swing.*;
import java.awt.Component;
import java.awt.*;
import java.util.*;
import java.rmi.RemoteException;
import java.awt.event.*;
import java.rmi.Naming;
import javax.swing.border.TitledBorder;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.borland.jbcl.layout.OverlayLayout2;
import com.borland.jbcl.layout.BoxLayout2;
import com.borland.jbcl.layout.PaneLayout;
import com.borland.jbcl.layout.*;

/**
 * Klientske okno nastenky
 *
 * @author Michal Trs
 */
public class PaintBoardWindow extends JFrame implements Runnable{
    BorderLayout borderLayout1 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();
    PaintingComp component1 = new PaintingComp();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel statusBar = new JLabel();
    JLabel LabelSelect = new JLabel();
    JComboBox ComboBoxColor = new JComboBox();
    TitledBorder titledBorder1 = new TitledBorder("");

// const
    public static final int PEN  = 1;
    public static final int LINE = 2;
    public static final int RECT = 3;
    public static final int OVAL = 4;
    public static final int TEXT = 5;

//  var
    PaintServerInterface psi = null;
    private int lastX = 0, lastY = 0;
    private boolean btnDown = false;
    private boolean isRunning = true;
    Thread t = null;
    Date lastUpdate = new Date();
    Map m = new HashMap();
    JButton BtnLine = new JButton();
    JButton BtnRect = new JButton();
    JButton BtnOval = new JButton();
    JButton BtnText = new JButton();
    JButton BtnPen = new JButton();
    TitledBorder titledBorder2 = new TitledBorder("");
    int select = PEN;

    /**
     * Constructor - vytvori novy frame a spusti nove vlakno pro obnovovani nastenky
     * @param p PaintServerInterface tento objekt se musi pred volanim tohoto construcotru nejprve vytvorit
     */
    public PaintBoardWindow(PaintServerInterface p) {
        try {
            jbInit();
            fillColors();
            psi = p;
            t = new Thread(this);
            t.start();
            component1.setData(psi.getBoard());
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Constructor - vytvori novy frame a spusti nove vlakno pro obnovovani nastenky
     * @param path String - jmeno nastenky, sam provede lookup
     */
    public PaintBoardWindow(String path) {
        try {
            jbInit();
            fillColors();
            psi = (PaintServerInterface) Naming.lookup(path);
            t = new Thread(this);
            t.start();
            component1.setData(psi.getBoard());
        } catch (Exception exception) {
            exception.printStackTrace();
        }

    }

    /**
     * Inicializece seznamu barev
     */
    private void fillColors() {
       m.put("red",Color.RED);
       m.put("black",Color.BLACK);
       m.put("blue",Color.BLUE);
       m.put("yellow",Color.YELLOW);
       m.put("cyan",Color.CYAN);
       m.put("green",Color.GREEN);
       m.put("orange",Color.ORANGE);
       m.put("magenta",Color.MAGENTA);
       m.put("pink",Color.PINK);
       m.put("gray",Color.GRAY);

       Object[] arr = m.keySet().toArray();
       Arrays.sort(arr);
       for (int i = 0; i < arr.length; i++) {
           ComboBoxColor.addItem(arr[i]);
       }
   }

   /**
    * vlakno starajici se o vykreslovani dat ze vzdalene nastenky
    */
   public void run() {
        while (isRunning) {
            try {
                if (psi.isUpDate(lastUpdate)) {
                    Shape[] data = psi.getBoard();
                    System.out.println(data.length);
                    component1.setData(data);
                    lastUpdate = new Date();
                }
            } catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }


    private void jbInit() throws Exception {
        component1 = new PaintingComp();
        getContentPane().setLayout(borderLayout1);
        component1.setBorder(BorderFactory.createLoweredBevelBorder());
        component1.setMinimumSize(new Dimension(320, 240));
        component1.setPreferredSize(new Dimension(800, 600));
        component1.addMouseMotionListener(new
                PaintBoardWindow_component1_mouseMotionAdapter(this));
        component1.addMouseListener(new
                                    PaintBoardWindow_component1_mouseAdapter(this));
        statusBar.setText("x: -- y: --");
        jPanel2.setLayout(gridLayout1);
        BtnLine.setBorder(titledBorder2);
        BtnLine.setToolTipText("");
        BtnLine.setText("Line");
        BtnLine.addActionListener(new PaintBoardWindow_BtnLine_actionAdapter(this));
        BtnRect.setBorder(titledBorder2);
        BtnRect.setText("Rectangle");
        BtnRect.addActionListener(new PaintBoardWindow_BtnRect_actionAdapter(this));
        BtnOval.setBorder(titledBorder2);
        BtnOval.setText("Oval");
        BtnOval.addActionListener(new PaintBoardWindow_BtnOval_actionAdapter(this));
        BtnText.setBorder(titledBorder2);
        BtnText.setText("Text");
        BtnText.addActionListener(new PaintBoardWindow_BtnText_actionAdapter(this));
        LabelSelect.setText("Pen");
        jLabel1.setText("Color");
        ComboBoxColor.setMinimumSize(new Dimension(70, 21));
        ComboBoxColor.setPreferredSize(new Dimension(70, 21));
        BtnPen.setBorder(titledBorder1);
        BtnPen.setText("Pen");
        BtnPen.addActionListener(new PaintBoardWindow_BtnPen_actionAdapter(this));
        this.setResizable(false);
        jPanel1.add(jLabel1);
        jPanel1.add(ComboBoxColor);
        jPanel1.add(BtnPen);
        jPanel1.add(BtnLine);
        jPanel1.add(BtnRect);
        jPanel1.add(BtnOval);
        jPanel1.add(BtnText);
        jPanel2.add(statusBar, null);
        jPanel2.add(LabelSelect, null);
        this.getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        this.getContentPane().add(component1, java.awt.BorderLayout.CENTER);
        this.getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);
    }

    public void component1_mousePressed(MouseEvent e) {
        lastX = e.getX();
        lastY = e.getY();
        btnDown = true;

        switch (select) {
        case PEN:  {
            break;
        }
        case LINE: {
            break;
        }
        case RECT: {
            break;
        }
        case OVAL: {
            break;
        }
        case TEXT: {
            DlgText dlg = new DlgText(this,"Type text...",true);
            dlg.show();
            String t = dlg.getText();
            if (t != null)
                try {
                    psi.paintText(e.getX(), e.getY(), t,
                                  (Color) m.get(ComboBoxColor.getSelectedItem()));
                } catch (RemoteException ex) {
                }
            break;
        }
        } // switch
    }

    public void component1_mouseReleased(MouseEvent e) {
        switch (select) {
        case PEN:  {
            btnDown = false;
            break;
        }
        case LINE: {
            try {
                psi.paintLine(lastX, lastY, e.getX(), e.getY(),
                              (Color) m.get(ComboBoxColor.getSelectedItem()));
            } catch (RemoteException ex) {
                ex.printStackTrace();
            }
            break;
        }
        case RECT: {
            try {
                psi.paintRect(lastX, lastY, e.getX(), e.getY(),
                              (Color) m.get(ComboBoxColor.getSelectedItem()));
            } catch (RemoteException ex) {
                ex.printStackTrace();
            }
            break;
        }
        case OVAL: {
            try {
                psi.paintOval(lastX, lastY, e.getX(), e.getY(),
                              (Color) m.get(ComboBoxColor.getSelectedItem()));
            } catch (RemoteException ex) {
                ex.printStackTrace();
            }
            break;
        }
        case TEXT: {
            break;
        }
        } // switch
    }

    public void component1_mouseDragged(MouseEvent e) {
        switch (select) {
        case PEN:  {
            if (btnDown) {
                try {
                    psi.paintLine(lastX, lastY, e.getX(), e.getY(),
                                  (Color) m.get(ComboBoxColor.getSelectedItem()));
                } catch (RemoteException ex) {
                    ex.printStackTrace();
                } finally {
                    lastX = e.getX();
                    lastY = e.getY();
                    statusBar.setText("x: " + lastX + ", y: " + lastY);
                }
            }
            break;
        }
        case LINE: {
            break;
        }
        case RECT: {
            break;
        }
        case OVAL: {
            break;
        }
        case TEXT: {
            break;
        }
        } // switch
    }

    public void BtnPen_actionPerformed(ActionEvent e) {
        select = PEN;
        LabelSelect.setText("Pen");
    }

    public void BtnLine_actionPerformed(ActionEvent e) {
        select = LINE;
        LabelSelect.setText("Line");
    }

    public void BtnRect_actionPerformed(ActionEvent e) {
        select = RECT;
        LabelSelect.setText("Rectangle");
    }

    public void BtnOval_actionPerformed(ActionEvent e) {
        select = OVAL;
        LabelSelect.setText("Oval");
    }

    public void BtnText_actionPerformed(ActionEvent e) {
        select = TEXT;
        LabelSelect.setText("Text");
    }

}


class PaintBoardWindow_BtnPen_actionAdapter implements ActionListener {
    private PaintBoardWindow adaptee;
    PaintBoardWindow_BtnPen_actionAdapter(PaintBoardWindow adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnPen_actionPerformed(e);
    }
}


class PaintBoardWindow_BtnText_actionAdapter implements ActionListener {
    private PaintBoardWindow adaptee;
    PaintBoardWindow_BtnText_actionAdapter(PaintBoardWindow adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnText_actionPerformed(e);
    }
}


class PaintBoardWindow_BtnOval_actionAdapter implements ActionListener {
    private PaintBoardWindow adaptee;
    PaintBoardWindow_BtnOval_actionAdapter(PaintBoardWindow adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnOval_actionPerformed(e);
    }
}


class PaintBoardWindow_BtnRect_actionAdapter implements ActionListener {
    private PaintBoardWindow adaptee;
    PaintBoardWindow_BtnRect_actionAdapter(PaintBoardWindow adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnRect_actionPerformed(e);
    }
}


class PaintBoardWindow_BtnLine_actionAdapter implements ActionListener {
    private PaintBoardWindow adaptee;
    PaintBoardWindow_BtnLine_actionAdapter(PaintBoardWindow adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnLine_actionPerformed(e);
    }
}


class PaintBoardWindow_component1_mouseAdapter extends MouseAdapter {
    private PaintBoardWindow adaptee;
    PaintBoardWindow_component1_mouseAdapter(PaintBoardWindow adaptee) {
        this.adaptee = adaptee;
    }

    public void mousePressed(MouseEvent e) {
        adaptee.component1_mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
    adaptee.component1_mouseReleased(e);
}

}


class PaintBoardWindow_component1_mouseMotionAdapter extends MouseMotionAdapter {
    private PaintBoardWindow adaptee;
    PaintBoardWindow_component1_mouseMotionAdapter(PaintBoardWindow adaptee) {
        this.adaptee = adaptee;
    }

    public void mouseDragged(MouseEvent e) {
        adaptee.component1_mouseDragged(e);
    }
}
