package net.michaltrs;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.*;
import java.awt.Color;

/**
 * RMI server, pri spusteni zalozi novou nastenku a zpristupni ji
 *
 * @author Michal Trs
 */
public class PaintServer extends UnicastRemoteObject implements PaintServerInterface {
    private List shapes = new ArrayList();
    private Date timeStamp = new Date();

    public PaintServer() throws RemoteException {
    }

    /**
     * Zalozi novy sdileny objekt nastenka.
     * Nazev servru je automaticky detekovan.
     * Lze spustit bez parametru - pouziji se defaultni hodnoty: port: 1099, jmeno nastenky: paintBoard.
     * Spusteni s parametry PaintBoardServer [jmeno_nastenky] [port]
     *
     * @param args String[]
     */
    public static void main(String[] args) {
        String addr = new IP().getHN();
        int portNum = 1099;
        String bName = "paintServer";

        if (args.length > 0) bName = args[0];
        if (args.length > 1) {
            try {
                portNum = Integer.parseInt(args[1]);
            } catch (Exception ex) {
                System.out.println("Port name must be a number! Using default port...");
            }
        }

        System.out.println("//"+addr+":"+portNum+"/"+bName);
        String classdir = System.getProperty("user.dir") + "\\classes\\";
        System.out.println("Classes dir: " + classdir);
        //System.out.println(new IP().getIP());
        //System.out.println(new IP().getHN());

        try {
            PaintServer ps = new PaintServer();
            System.setProperty("java.rmi.server.codebase", "file:" + classdir);
            Naming.rebind("rmi://"+addr+":"+portNum+"/"+bName, ps);
            System.out.println("new server created!");
        } catch (Exception ex) {
            System.out.println("Can't connect to Naming service! Are you sure that RMIregistry is running?");
            System.exit(1);
        }
    }

    /**
     * Vykresli caru na sitovou nastenku
     *
     * @param x1 int
     * @param y1 int
     * @param x2 int
     * @param y2 int
     * @param c Color
     * @throws RemoteException
     */
    public void paintLine(int x1, int y1, int x2, int y2, Color c) throws
            RemoteException {
        shapes.add(new Line(x1, y1, x2, y2, c));
        timeStamp = new Date();
        System.out.println("paintLine " + timeStamp);
   }

   /**
    * Vykresli obdelnik na sitovou nastenku
    *
    * @param x1 int
    * @param y1 int
    * @param x2 int
    * @param y2 int
    * @param c Color
    * @throws RemoteException
    */
   public void paintRect(int x1, int y1, int x2, int y2, Color c) throws
            RemoteException {
        shapes.add(new Rect(x1, y1, x2, y2, c));
        timeStamp = new Date();
        System.out.println("paintRect " + timeStamp);
    }

    /**
     * Vykresli elipsu na sitovou nastenku
     *
     * @param x1 int
     * @param y1 int
     * @param x2 int
     * @param y2 int
     * @param c Color
     * @throws RemoteException
     */
    public void paintOval(int x1, int y1, int x2, int y2, Color c) throws
            RemoteException {
        shapes.add(new Oval(x1, y1, x2, y2, c));
        timeStamp = new Date();
        System.out.println("paintOval " + timeStamp);
    }

    /**
     * Vypise text na sitovou nastenku
     *
     * @param x int
     * @param y int
     * @param text String
     * @param c Color
     * @throws RemoteException
     */
    public void paintText(int x, int y, String text, Color c) throws
            RemoteException {
        shapes.add(new Text(x, y, text, c));
        timeStamp = new Date();
        System.out.println("paint Text " + timeStamp + ": " + text);
    }

    /**
     * Poskytne doposud vykreslene obekty na nastenku
     *
     * @return Shape[] pole grafickych objektu
     * @throws RemoteException
     */
    public Shape[] getBoard() throws RemoteException {
        Object[] objs = shapes.toArray();
        Shape[] shas = new Shape[objs.length];
        for (int i = 0; i < objs.length; i++)
            shas[i] = (Shape) objs[i];
        System.out.println("getBoard " +shas.length);
        return shas;
    }

    /**
     * Vraci true, kdyz se stva nastenky od posledniho volani getBoard() nezmenil
     *
     * @param d Date
     * @return boolean
     * @throws RemoteException
     */
    public boolean isUpDate(Date d) throws RemoteException {
        return timeStamp.getTime() > d.getTime();
    }

    /**
     * Vymaze vsechny objekty z nastenky
     *
     * @throws RemoteException
     */
    public void clearBoard() throws RemoteException {
        shapes.clear();
    }


}
