library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity vga_control is
   Generic (
      --  size in px * 8
      batt_h         : natural := 15;
      batt_w         : natural := 5;
      ball_r         : natural := 1;
      screen_height  : natural := 60;
      screen_width   : natural := 80
   );	 
    Port ( 
      CLK      : in std_logic;
      AS_RESET : in std_logic;
      P1_UP    : in std_logic;
      P1_DOWN  : in std_logic;
      P2_UP    : in std_logic;
      P2_DOWN  : in std_logic;
      ball_x   : out natural;
      ball_y   : out natural;
      batt1    : out natural;
      batt2    : out natural);
end vga_control;

architecture Behavioral of vga_control is

type state_type is (Start,XpYp,XmYm,XmYp,XpYm);
signal next_state, current_state: state_type;

type dir is (up,down,start);

signal ball_xcnt	: natural;
signal ball_ycnt	: natural;
signal ball_xdir	: dir;
signal ball_ydir	: dir;

signal cnt_wait   : std_logic_vector(19 downto 0);	 
signal p1_up_reg  : std_logic;
signal p1_down_reg: std_logic;
signal p2_up_reg  : std_logic;
signal p2_down_reg: std_logic;
signal read_write : std_logic;
signal batt1_reg  : natural;
signal batt1_dir  : std_logic; --0 up, 1 down
signal batt2_reg  : natural;
signal batt2_dir  : std_logic;

-- podminky pro odraz micku
  signal podlaha	: boolean;
  signal strop		: boolean;
  signal levap		: boolean;
  signal pravap	: boolean;

  signal pruchodl	: boolean;
  signal pruchodp	: boolean;

begin

--input registers-----------------------
input_reg:process(CLK,AS_RESET)
  begin
    if AS_RESET = '1' then
	    p1_up_reg <= '0';
		 p1_down_reg <= '0';
		 p2_up_reg <= '0';
		 p2_down_reg <= '0';
    elsif CLK = '1' and CLK'event then
	    p1_up_reg <= P1_UP;
		 p1_down_reg <= P1_DOWN;
		 p2_up_reg <= P2_UP;
		 p2_down_reg <= P2_DOWN;
    end if;
  end process;
----------------------------------------

--direction of batt 1 moving------------
batt1_direction:process(CLK, AS_RESET)
  begin
	if AS_RESET = '1' then
		batt1_dir <= '0';
	elsif CLK = '1' and CLK'event then
	  if (p1_up_reg = '1') and (p1_down_reg = '0') then
	    batt1_dir <= '0';
	  elsif (p1_up_reg = '0') and (p1_down_reg = '1') then 
	    batt1_dir <= '1';
	  end if;
	end if;
  end process;
----------------------------------------

--direction of batt 2 moving------------
batt2_direction:process(CLK, AS_RESET)
  begin
	if AS_RESET = '1' then
		batt2_dir <= '0';
	elsif CLK = '1' and CLK'event then
	  if (p2_up_reg = '1') and (p2_down_reg = '0') then
	    batt2_dir <= '0';
	  elsif (p2_up_reg = '0') and (p2_down_reg = '1') then 
	    batt2_dir <= '1';
	  end if;
	end if;
  end process;
----------------------------------------
 
--counter for vga delay	----------------
cnt:process(CLK, AS_RESET)
	begin
		if AS_RESET = '1' then
			cnt_wait <= (others => '0');
		elsif CLK = '1' and CLK'event then
			cnt_wait <= cnt_wait + '1';
		end if;
	end process;
----------------------------------------

--read and write enable-----------------
read_write <= '1' when cnt_wait = 0	
 else '0'; 
----------------------------------------


-- ball position counter ---------------
----------------------------------------
process(CLK, AS_RESET)
begin
	if AS_RESET = '1' then 
		ball_xcnt <= 40;
	elsif CLK = '1' and CLK'event then
		if ball_xdir = start then
			ball_xcnt <= 40;
		elsif read_write = '1' then
			if ball_xdir = up then
				ball_xcnt <= ball_xcnt + 1;
			else
				ball_xcnt <= ball_xcnt - 1;
			end if;
		end if;
	end if;
end process;

process(CLK, AS_RESET)
begin
	if AS_RESET = '1' then 
		ball_ycnt <= 30;
	elsif CLK = '1' and CLK'event then
		if ball_ydir = start then
			ball_ycnt <= 30;
		elsif read_write = '1' then
			if ball_ydir = up then
				ball_ycnt <= ball_ycnt + 1;
			else
				ball_ycnt <= ball_ycnt - 1;
			end if;
		end if;
	end if;
end process;

--moving of batt1-----------------------
move_batt1: process(CLK, AS_RESET)
      begin
      if AS_RESET = '1' then
	      batt1_reg <= 22;
	   elsif CLK = '1' and CLK'event then
	      if (read_write = '1') and  (batt1_dir =	'0') then
			  batt1_reg  <= batt1_reg + 1 ;
	   	  if batt1_reg >= 60-batt_h then
			    batt1_reg <= 60-batt_h ;
            end if;
			elsif (read_write = '1') and  (batt1_dir =	'1') then 
			  batt1_reg  <= batt1_reg - 1 ;
	   	  if batt1_reg <= 0 then
			    batt1_reg <= 0;
            end if;
			else  
			  batt1_reg  <= batt1_reg;  
		   end if;
		end if;
	 end process;
----------------------------------------

--moving of batt2-----------------------
move_batt2: process(CLK, AS_RESET)
      begin
      if AS_RESET = '1' then
	      batt2_reg <= 22;
	   elsif CLK = '1' and CLK'event then
	      if (read_write = '1') and  (batt2_dir =	'0') then
			  batt2_reg  <= batt2_reg + 1 ;
	   	  if batt2_reg >= 60-batt_h then
			    batt2_reg <= 60-batt_h;
            end if;
			elsif (read_write = '1') and  (batt2_dir =	'1') then 
			  batt2_reg  <= batt2_reg - 1 ;
	   	  if batt2_reg <= 0 then
			    batt2_reg <= 0;
            end if;
			else  
			  batt2_reg  <= batt2_reg;  
		   end if;
		end if;
	 end process;
----------------------------------

--writing output out--------------
batt2 <= batt2_reg;
batt1 <= batt1_reg;
ball_x <= ball_xcnt;
ball_y <= ball_ycnt;
----------------------------------

--FSM for ball moving-------------
-- state registers
process(CLK, AS_RESET)
  begin
    if (AS_RESET='1') then
       current_state <= Start;
    elsif (CLK'event and CLK='1') then
	    current_state <= next_state;
	 end if;
  end process;	

  podlaha	<= (ball_ycnt = screen_height-ball_r);	
  strop		<=	(ball_ycnt = ball_r);
  levap		<=	(ball_xcnt = ball_r + batt_w) and (ball_ycnt >= batt1_reg- ball_r) and (ball_ycnt <= batt1_reg + batt_h+ ball_r);
  pravap		<= (ball_xcnt = screen_width-ball_r - batt_w) and (ball_ycnt >= batt2_reg - ball_r) and (ball_ycnt <= batt2_reg + batt_h + ball_r);

  pruchodl	<= (ball_xcnt = 0);
  pruchodp	<=	(ball_xcnt = screen_width);

-- next state logic
process(current_state, podlaha, strop, levap, pravap, pruchodl, pruchodp, p1_up_reg)
  begin
    next_state <= current_state;

    case current_state is
	   when Start => 
	 	  if p1_up_reg = '1' then 
			 next_state <=  XpYp;
		  end if;
		
		when XpYp =>  -- doprava dolu
		  if podlaha then 
		    next_state <= XpYm;
        elsif pravap then -- trefa palky	2 
		    next_state <= XmYp;
        elsif pruchodp then --netrefa palky 2
		    next_state <= Start;
		  end if;      
     	 
	  	when XpYm =>	-- doprava nahoru
		  if strop then	 --zed
		    next_state <= XpYp;
		  elsif pravap then --trefa palky 2
		    next_state <= XmYm;		
		  elsif pruchodp then --netrefa palky 2
		    next_state <= Start;
		  else
			end if;       		
     	  
	  when XmYp =>	-- doleva dolu
		  if podlaha then	 --zed
		    next_state <= XmYm;
        elsif levap then --trefa palky 1
		    next_state <= XpYp;
        elsif pruchodl then --netrefa palky 1
		    next_state <= Start;
			end if;          	
	  
	  when XmYm => -- doleva nahoru		  
		  if strop then	 --zed
		    next_state <= XmYp;
        elsif levap then --trefa palky 1
		    next_state <= XpYm;
        elsif pruchodl then --netrefa palky 1
		    next_state <= Start;
			end if; 
		 
	 end case;
  end process; 

-- output logic
process(current_state)
  begin
    case current_state is
    when Start => 
	   ball_xdir <= start;
		ball_ydir <= start;
  	 when XpYp =>
	   ball_xdir <= up;
		ball_ydir <= up;
	 when XpYm =>
	 	ball_xdir <= up;
		ball_ydir <= down;
	 when XmYp =>
	   ball_xdir <= down;
		ball_ydir <= up;
    when XmYm =>
	   ball_xdir <= down;
		ball_ydir <= down;
    end case;
  end process;
---------------------------------------
end Behavioral;
