#include <p30f4013.h>

#define MAXOUT 25

int actTime = 0;

void UARTinit(){
	U1MODE = 0x8400;          // typ prenosu - bez parity, 1 stop, 8bit
	U1BRG = 47;               // nast. rychlosti 7,3728 MHz/(16*U1BRG)
	U1STA = 0x0000;           // transmit enable
}

void ADinit(){
	ADPCFG = 0xFFEF;          // all PORTB = Digital; RB4 = analog
	ADCON1 = 0x0000;          // SAMP bit = 0 ends sampling ...
	// and starts converting
	ADCHS = 0x0004;           // Connect RB4/AN4 as CH0 input ..
	ADCSSL = 0;
	ADCON3 = 0x0002;          // Manual Sample, Tad = internal 2 Tcy
	ADCON2 = 0;
	ADCON1bits.ADON = 1;      // turn ADC ON
}

void timer3Init(){
	IPC1bits.T3IP = 7;        // set priority level
	IFS0bits.T3IF = 0;
	IEC0bits.T3IE = 1;
	T3CON = 0x0030;           // fosc/4, prescale bity<5:4>1:256=11
	PR3 = 2880-1;             // hodnota->100ms preruseni (2880-1)
	T3CONbits.TON = 1; 
}


void delay(int time) {
	int i=0, j=0;

	while (j <= time) {
		while (i <= 25) {
			i++;
			asm ("nop");
			asm ("nop");
			asm ("nop");
			asm ("nop");
		}
		j++;
		i = 0;
	}
}


int ADconvert() {
	ADCON1bits.SAMP = 1;      // start sampling ...
	delay(100);               // for 100 mS
	ADCON1bits.SAMP = 0;      // start Converting
	while (!ADCON1bits.DONE); // conversion done?
	return ADCBUF0;           // yes then get ADC value
}


void __attribute__((interrupt))
_T2Interrupt(void) {

   IFS0bits.T2IF = 0;
   LATBbits.LATB0 = !LATBbits.LATB0;
}


void prnStar(int tm, int value) {
   // vstupni rozsah
   const int minIn = 0;
   const int maxIn = 4095;
   // vystup tj pocet mezer pred hvezdickou
   const int minOut = 0;
   const int maxOut = MAXOUT; // radek = 80 - rezerva
   // prevodni pomer (100mV == 1 mezera)
   const double scale = (maxIn-minIn) / (maxOut-minOut);

   char str[MAXOUT+1];

   int i=0;
   int pos=0;

   for (i=0; i < (int)(value/scale); i++) {
      if (i >= minOut) {
         str[pos++] = ' ';
      }
   }
   str[pos++] = '*';
   str[pos] = '\0';
   
   printf("%05d|%s\n\r",tm,str);
}


void __attribute__((interrupt))
_T3Interrupt(void) {
	int val;

	IFS0bits.T3IF = 0;
	val = ADconvert();
	prnStar(actTime,val);
	actTime = (actTime+100)%2000;
}


int main() {
	int val;

	UARTinit();
	ADinit();
	timer3Init();

/*	while(1){
		val = ADconvert();
      //	printf("%4d\n\r",val);
		prnStar(500,val);
		delay(1000);
	}*/

	while (1);
}
