unit uSeznam;

interface

type

 tBod = record
   x,y: integer;
  end;

  ptrCell = ^tCell;
  tCell = record
    prev, next: ptrCell;
    point: tBod;
  end;

  tKlic = (x,y);

tSeznam = class
   public
    constructor Create;
    destructor Destroy; {zrusi vsechna data v seznamu}
    procedure Prazdny;  {vyhodi vsechny bunky ze seznamu, ale nerusi data!!!}
    procedure Pridej(bod: tBod); {pridani noveho prvku na konec spojoveho seznamu}
    procedure SetAktualni(prvek: ptrCell);
    procedure ZaradPrvek(Prvek: ptrCell);
    function Prvni: ptrCell;
    function Dalsi: ptrCell;
    function PrvniHodn: tBod;
    function DalsiHodn: tBod;
    procedure Serad(klic: tKlic);
    function QKonec: Boolean;
    function QPrazdny: Boolean;
    function PocPrvku: integer;
    procedure PripojSeznam(Sez: tSeznam); {pripoji Sez nakonec seznamu}
    function SpojSeznamy(Sez1,Sez2: tSeznam): tSeznam;
    function GetAktualni: tBod;
    {preskoci prvky stejne hodnoty jak Hod podle x nebo y}
    function PreskocStejne(Hod: integer; klic: tKlic): tSeznam;
   private
    pPrvku: integer;
    first, last, akt: ptrCell;
  end;

  {A > B = 1, A < B = -1, A = B = 0}
  function Porovnej(A,B: tBod; klic: tKlic): integer; overload;{body s prioritou klice}
  function Porovnej(A,B: integer): integer; overload;

implementation

function Porovnej(A,B: tBod; klic: tKlic): integer;
begin
  if klic = x then
  begin
    result:= A.x - B.x;
    if result = 0 then result:= A.y - B.y;
  end else
  begin
    result:= A.y - B.y;
    if result = 0 then result:= A.x - B.x;
  end
end;

function Porovnej(A, B: integer): integer;
 begin
  if A - B <> 0 then result:= (A - B) div abs(A-B) else result:= 0;
 end;

{tSeznam}

function tSeznam.Dalsi: ptrCell;
begin
  akt:= akt^.next;
  result:= akt;
end;

constructor tSeznam.Create;
 var n: ptrCell;
begin
  new(n);
  first:= n;
  n^.point.x:= high(integer);
  n^.point.y:= high(integer);
  n^.prev:= nil;
  new(n);
  last:= n;
  n^.point.x:= high(integer);
  n^.point.y:= high(integer);
  n^.next:= nil;
  Prazdny;
end;

procedure tSeznam.Pridej(bod: tBod);
 var p: ptrCell;
begin
  new(p);
  p^.point:= bod;
  ZaradPrvek(p);
end;

procedure tSeznam.ZaradPrvek(Prvek: ptrCell);
begin
  {nastaveni ukazatelu pred prvkem}
  prvek^.prev:= last^.prev;
  last^.prev^.next:= prvek;
  {nastaveni ukazatelu za prvkem}
  last^.prev:= prvek;
  prvek^.next:= last;
  inc(pPrvku);
  akt:= prvek;
end;

function tSeznam.Prvni: ptrCell;
begin
  akt:= first^.next;
  result:= akt;
end;

function tSeznam.QKonec: Boolean;
 begin result:= (akt^.next = last) or (pPrvku = 0) end;

procedure tSeznam.Serad(klic: tKlic);
 type tA = array of ptrCell;
 var  A:tA; i: integer;

 procedure trideni(L,R: integer);
  var i,j: integer;
      M: tBod;

   procedure prohod(var i,j: integer);
    var w: ptrCell;
   begin  w:=A[i]; A[i]:=A[j]; A[j]:=w; inc(i); dec(j) end;

 begin
   i:=L; j:=R;
   M.x:= A[(L+R) div 2].point.x;
   M.y:= A[(L+R) div 2].point.y;
   repeat
     while Porovnej(A[i]^.point,M,klic) < 0 {A[i]^.point < M} do Inc(i);
     while Porovnej(A[j]^.point,M,klic) > 0 {A[j]^.point > M} do Dec(j);
     if i <= j then prohod(i,j);
   until i > j;
   if L < j then trideni(L,j);
   if i < R then trideni(i,R);
 end;

begin
  {prekopirovani ukazatelu na jednotlive budky spojoveho seznamu do pole, krome prvni a posledni}
  SetLength(A,pPrvku);
  A[0]:= Prvni; i:=0;
  while not QKonec do begin
    inc(i); A[i]:= Dalsi;
  end;

  trideni(0,pPrvku-1);  {Samotne serazeni ukazatelu v poli} {QuickSort}

  {vraceni prvku do seznamu}
  Prazdny;
  for i:=0 to Length(A)-1 do ZaradPrvek(A[i]);
end;

destructor tSeznam.Destroy;
 var p: ptrCell;
begin
  akt:= first;
  while akt <> last do
  begin
   p:= akt;
   akt:= akt.next;
   dispose(p);
  end;
  dispose(last);
end;

function tSeznam.PocPrvku: integer;
 begin result:= pPrvku; end;

procedure tSeznam.Prazdny;
begin
  first^.next:= last;
  last^.prev:= first;
  pPrvku:= 0;
  akt:= nil;
end;

procedure tSeznam.SetAktualni(prvek: ptrCell);
 begin akt:= prvek; end;


procedure tSeznam.PripojSeznam(Sez: tSeznam);
begin
  if (Sez = nil) or Sez.QPrazdny then exit;
  last^.prev^.next:= Sez.first^.next;        // spojeni seznamu a sez
  Sez.first^.next^.prev:= last^.prev^.next;  // spojeni sez a seznamu
  last:= Sez.last;
  pPrvku:= pPrvku + Sez.pPrvku;
end;

function tSeznam.SpojSeznamy(Sez1, Sez2: tSeznam): tSeznam;
begin
 result:= tSeznam.Create;
 if Sez1 <> nil then
  if not Sez1.QPrazdny then
  begin
    result.Pridej(sez1.PrvniHodn);
    while not sez1.QKonec do result.Pridej(Sez1.DalsiHodn);
  end;
 if Sez2 <> nil then 
  if not Sez2.QPrazdny then
  begin
    result.Pridej(Sez2.PrvniHodn);
    while not sez2.QKonec do result.Pridej(Sez2.DalsiHodn);
  end;
end;

function tSeznam.GetAktualni: tBod;
begin
  result:= akt^.point;
end;

function tSeznam.DalsiHodn: tBod;
begin
  akt:= akt^.next;
  result:= akt^.point;
end;

function tSeznam.PrvniHodn: tBod;
begin
  akt:= first^.next;
  result:= akt^.point;
end;

function tSeznam.QPrazdny: Boolean;
begin
  result:= pPrvku = 0;
end;

function tSeznam.PreskocStejne(Hod: integer; klic: tKlic): tSeznam;
begin
  result:= tSeznam.Create;
  case klic of
    x: while (Hod = akt^.next^.point.x) and (not QKonec) do
    result.Pridej(DalsiHodn);
    y: while (Hod = akt^.next^.point.y) and (not QKonec) do result.Pridej(DalsiHodn);
  end;
end;

end.
