program prefix;  
{$APPTYPE CONSOLE}

 uses
  SysUtils, zasobnik;

 var s:string;

 const Operatory: array[0..3] of Char=('*','/','+','-');

 function JeOperator(const c:Char):Boolean;
  var i:integer;
  begin
   Result:=false;
   for i:=Low(Operatory)to High(Operatory)do
    if Operatory[i]=c then result:=true;
  end;

  { Doplni zavorky aby na nejvyssi urovni byl maximalne 1 typ operatoru. }
 procedure DoplnZavorky(var S:string; Operator:Char);
  var i,j,vnor,ind:integer;
  begin
   i:=1;
   while i<=Length(s) do
    begin
     if (s[i]=Operator)and(i>1)and(i<Length(s))then
      begin
       if (s[i-1]=')')then
        begin
         vnor:=0; ind:=i;
         for j:=i-2 downto 1 do
          if (s[j]='(')and(vnor=0)then begin ind:=j;break end
          else if s[j]='(' then Dec(vnor)
          else if s[j]=')' then Inc(vnor);
         Insert('(',s,ind); Inc(i);
        end; 
       if (s[i+1]='(') then
        begin
         vnor:=0; ind:=i;
         for j:=i+2 to Length(s) do
          if (s[j]=')')and(vnor=0)then begin ind:=j;break end
          else if s[j]='(' then Inc(vnor)
          else if s[j]=')' then Dec(vnor);
         Insert(')',s,ind);
        end;
       if (s[i+1]<>'(') then
        begin
         if i+2<=length(s)then Insert(')',s,i+2) else s:=s+')';
        end;
       if (s[i-1]<>')')then
        begin
         Insert('(',s,i-1); Inc(i);
        end;
      end;
     Inc(i);
    end;
  end;

 { Hleda nejmene vnoreny operator, kdyz ho najde tak se funkce sama zavola nejdriv na pravou
   a pak na levou stranu vyrayu. Pote uloyi operand na zasobnik. Kdyz nenajde operator, je v
   s jen operand a ten ulozi na zasobnik }

 procedure ZpracujVyraz(s:string; var Zas:TZasobnik);
  var i,AktVnoreni,vnoreni,ind:integer;
  begin
   ind:=1; // Nalezeny operator.
   vnoreni:=High(integer); // Uroven vnoreni operatoru.
   AktVnoreni:=0; // Aktualni uroven vnoreni pri prochazeni.
   for i:=1 to Length(s)do
    begin
     // Kdyz je zde operator a je mene vnoreny nez doposud nalezeny => ulozit.
     if (JeOperator(s[i]))and(aktVnoreni<vnoreni)then
      begin ind:=i; vnoreni:=AktVnoreni end
     else if s[i]='(' then Inc(aktVnoreni) // Leva zavorka => vetsi vnoreni.
     else if s[i]=')' then Dec(aktVnoreni); // Prava zavorka => mensi vnoreni.
    end;
   if ind>1 then // Nalezen nejaky operator.
    begin
     ZpracujVyraz(Copy(s,ind+1,Length(s)-ind),Zas); // Pravy operand - rekurze.
     ZpracujVyraz(Copy(s,1,ind-1),Zas); // Levy operand - rekurze.
     Zas.Vloz(s[ind]); // Operator - ulozeni na zasobnik.
    end
   else // Zadny operator nenalezen => operand => ulozeni na zasobnik.
    for i:=Length(s)downto 1 do
     if not(s[i]in['(',')'])then Zas.Vloz(s[i]);
  end;

 function GetPrefix(s:string):string;
  var Zas:TZasobnik; i:integer;
  begin
  
   // Zazavorkovani kvuli priorite.
   for i:=Low(Operatory)to High(Operatory) do DoplnZavorky(s,Operatory[i]);

   Zas:=TZasobnik.Create;
   ZpracujVyraz(s,Zas); // Spusteni rekurze.
   result:='';
   while not Zas.Prazdny do Result:=Result+Zas.Pop; // Pro vypis.
   Zas.Free;
  end;

begin
Write('Zadej vyraz v infixovem zapisu: ');Readln(s);
Write('Vyraz v prefixovem zapisu: ');
while s<>'' do
 begin
  Writeln(GetPrefix(s));
  Writeln('');
  Readln(s);
 end;
end.
