-- Michal Trs, trsm1@fel.cvut.cz

-- This block has one 8-bit input A, one 1-bit input SEL and one 8-bit output Y.
-- It implements a multiplexer that passes Y = A when SEL='1', and Y = all zeros when SEL='0'.
-- This can also be implemented as a group of logical ANDs between Ai and SEL (hence the name of the block).

-- Implement a VHDL entitiy describing the "and" block.

library ieee; 
use ieee.std_logic_1164.all;

entity AND_BLOCK is
  port (
    A:   in std_logic_vector(7 downto 0);
    SEL: in std_logic;    
    Y : out std_logic_vector(7 downto 0)
  );
end AND_BLOCK;


architecture AND_BLOCK_BODY of AND_BLOCK is
begin 
   Y <= A when SEL = '1' else (others => '0');
end AND_BLOCK_BODY;