-- Michal Trs, trsm1@fel.cvut.cz

-- The controlleris a synchronous sequential circuit that has 2 inputs and 6 outputs.
-- Inputs: START, ZERO, CLK, ARES (asynchronous reset, not shown in the picture!)
-- Outputs: DO_MULT, LOAD_A, LOAD_B, STORE_C, STORE_D, LOAD_CNT.
-- 
-- Read the description of the multiplier.
-- 
-- Draw a state diagram or a transition table of the finite state machine (FSM).
-- Write a VHDL entity CONTROLLER implementing the FSM.
-- 
-- Write the FSM using 3 processes. Use a Mealy-type FSM.
-- 
-- Use the asynchronous reset input to set the correct initial state of the FSM.

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity CONTROLLER is
   port(
      CLK      : in std_logic;
      ARES     : in std_logic;
      START    : in std_logic;
      ZERO     : in std_logic;
      DO_MULT  : out std_logic;
      LOAD_A   : out std_logic;
      LOAD_B   : out std_logic;
      STORE_C  : out std_logic;
      STORE_D  : out std_logic;
      LOAD_CNT : out std_logic   
   );
end CONTROLLER;

architecture MEALY of CONTROLLER is
   type  t_state is (st_idle, st_loadb, st_compute, st_stored, st_storec);
   signal cur_state, next_state : t_state;
begin

   reg: process(CLK,ARES)
   begin
      if ARES = '1' then 
         cur_state <= st_idle;
      elsif CLK = '1' and CLK'event then
         cur_state <= next_state;
      end if;   
   end process;


   next_logic: process(cur_state, START, ZERO)
   begin
      next_state <= cur_state;      
      case cur_state is
         when st_idle =>
            if START = '1' then 
               next_state <= st_loadb;
            end if;
         when st_loadb =>
            next_state <= st_compute;
         when st_compute =>
            if ZERO = '1' then 
               next_state <= st_stored;
            end if;   
         when st_stored =>
            next_state <= st_storec;
         when st_storec =>
            next_state <= st_idle;      
      end case;   
   end process;
   
   
   output_logic: process(cur_state, START, ZERO)
   begin
      DO_MULT  <= '0';
      LOAD_A   <= '0';
      LOAD_B   <= '0';
      STORE_C  <= '0';
      STORE_D  <= '0';
      LOAD_CNT <= '0';      
      
      case cur_state is
         when st_idle =>
            if START = '1' then
               LOAD_A <= '1';             
            end if;    
         when st_loadb =>
            LOAD_B   <= '1';
            LOAD_CNT <= '1';
         when st_compute =>
            DO_MULT <= '1';   
         when st_stored =>
            STORE_D <= '1';
         when st_storec =>
            STORE_C <= '1';
      end case;
   end process;

end MEALY;
   
