-- Michal Trs, trsm1@fel.cvut.cz

-- Write a VHDL testbench COUNTER_TEST  to test the counter.

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity COUNTER_TEST is
end COUNTER_TEST;

architecture TESTBENCH of COUNTER_TEST is
  
   component COUNTER is
    port(
      I:    in std_logic_vector(2 downto 0);
      LOAD: in std_logic;
      CE:   in std_logic;
      CLK:  in std_logic;
      ZERO:out std_logic
    );
   end component;

   signal t_i:     std_logic_vector(2 downto 0);
   signal t_clk:   std_logic := '0';
   signal t_load:  std_logic;
   signal t_ce:    std_logic;
   signal t_zero:  std_logic; 
   
begin   
   uut: COUNTER port map(
      I    => t_i,
      CLK  => t_clk,
      LOAD => t_load,
      CE   => t_ce,
      ZERO => t_zero      
   );
   
   -- clock generator
   t_clk <= not t_clk after 20 ns;
   
  
   tst:process
   begin
      -- reset 
      t_load <= '1';
      t_i <= "000";
      t_ce <= '0';
      wait for 100 ns;
       
      
      -- test
      t_i <= "010";
      t_load <= '1';
      
      wait for 10 ns;
      wait until t_clk = '1' and t_clk'event;
      t_load <= '0';
      t_ce <= '1';       
      wait for 400 ns;

      t_i <= "100";
      t_load <= '1';
      
      wait for 10 ns;
      wait until t_clk = '1' and t_clk'event;
      t_load <= '0';
      t_ce <= '1';
      wait for 400 ns;
            
      t_i <= "001";
      t_load <= '1';
      
      wait for 10 ns;
      wait until t_clk = '1' and t_clk'event;
      t_load <= '0';
      t_ce <= '1';


      wait for 400 ns;
      
       
      wait; 
   end process;
    
end TESTBENCH;