-- Michal Trs, trsm1@fel.cvut.cz

-- The shift register is capable of 3 operations: hold data, shift, load.
-- It has 5 inputs and 2 outputs.
--
-- Data inputs: one 8-bit data input I, one 1-bit data shft-in input SI,
-- Control inputs: LOAD, SHIFT, CLK
-- Outputs: one 8-bit data output O, one 1-bit shift-out SO.
-- 
-- The shift register consists of 2 parts: a register and a shifter.
-- 
-- The load operation has higher priority than the shift operation. All inputs are synchronous to the clock.
--
-- Write a VHDL entity SHIFT_REG implementing the shift register.

library IEEE;
use ieee.std_logic_1164.all;

entity SHIFT_REG is
 port(
   I:    in std_logic_vector(7 downto 0);
   SI:   in std_logic;
   LOAD: in std_logic;
   SHIFT:in std_logic;
   CLK:  in std_logic;
   O:   out std_logic_vector(7 downto 0);
   SO:  out std_logic
 );    
end SHIFT_REG;


architecture SHIFT_REG_BODY of SHIFT_REG is

   component SHIFTER port (
     SI: in std_logic;
     I : in std_logic_vector(7 downto 0);
     O : out std_logic_vector(7 downto 0);
     SO: out std_logic );
   end component;  
   
   component REG port(
     I:    in   std_logic_vector(7 downto 0);
     CLK:  in   std_logic;
     CE:   in   std_logic;
     RST:  in   std_logic;
     O:    out  std_logic_vector(7 downto 0) );
   end component;

   signal dff_in   : std_logic_vector(7 downto 0);
   signal dff_out  : std_logic_vector(7 downto 0);
   signal sh_out   : std_logic_vector(7 downto 0);
   signal dff_ce   : std_logic;
    
begin
    
   comp_shifter: SHIFTER port map(
     SI => SI,
     I  => dff_out,
     O  => sh_out,
     SO => SO
   );
   
   comp_reg: REG port map(
     I   => dff_in,
     CLK => CLK,
     CE  => dff_ce,
     RST => '0',
     O   => dff_out
   );
   
   dff_in <= I when LOAD = '1'
        else sh_out;
        
   dff_ce <= LOAD or SHIFT;        
   
   O <= dff_out;
   
   
end SHIFT_REG_BODY;
    