; semestralka IDE identifikator
; Michal Trs
; ver 2

org 256
	cld
	xor si,si	; ukazatel na rdreg
	mov bp,mystat	; statut 
	xor bx,bx	; master / slave
	mov di,buf	; index v bufferu

start:	mov dx,[streg + SI]
	in al,dx
	and al,0EFh	; master
	test bx,1
	jz master
	or al,10h	; slave
master:	out dx,al	; nastavim master / slave
	inc dx
	mov al,0ECh	; identify IDE
	out dx,al
	xor cx,cx
drvrdy:	in al,dx
	test al,80h
	loopnz drvrdy
	inc al		; test pritomnosti rabpce
	jz nextide
	dec al		; test pritomnosti jednotky
	jz nextdrv
	inc byte [bufoff]
	cmp al,51h	; je to CD?
	jz cd
	mov al,[bufoff]	
	shl al,3
	mov byte [bp],al
	mov cx,256
	mov dx,[rdreg + SI]
ctihdd:	in ax,dx
	stosw
	loop ctihdd
	jmp nextdrv
cd:	mov al,0A1h	; identify ATAPI
	out dx,al
	xor cx,cx
cdrdy:	in al,dx
	test al,80h
	loopnz cdrdy
	mov cx,256
	mov dx,[rdreg + SI]
cticd:	in ax,dx
	stosw
	loop cticd
	mov al,[bufoff]
	shl al,3
	add al,100b
	mov byte [bp],al
nextdrv:and byte [bp],0FEh
nextide:inc bx
	inc bp
	test bx,1
	jnz start
	add si,2
	cmp bx,8
	jnz start

; ---------------vypis init ----------------

	mov ah,0Fh	;
	int 10h		; nacteni zobrazovaciho modu do AL
	xor ah,ah	; vynulovani AH
	push ax		; ulozim puvodni rezim graficke karty na zasobnik
	mov al,3	; AL je rezim , AH nastaveni
	int 10h		; nastaveni rezimu 16 barev 40 x 25 radku
	mov ax,0B800h 
	mov es,ax

; ------------------vypis ------------------
	
	xor di,di
	mov ax,7120h	
	mov cx,80
	rep stosw
	mov di,26
	mov si,topl
	call prtstr
	mov di,3840
	mov cx,80
	rep stosw
	mov di,3870
	mov si,botl
	call prtstr

; --------- menu ------------

	mov ax,[bot]
	call setbeg
		
	xor bx,bx
stm:	mov al,[mystat+bx]
	shr al,2
	mov byte [barva],mi
	jnc inst
	mov byte [barva],mins		
inst:	mov si,ide
	call prtstr
	test bl,1
	jnz ninc
	inc cx
ninc	mov ax,cx
	call prt10
	test bl,1
	mov si,m
	jz mas
	mov si,s
mas:	call prtstr
	call eoln
	inc bx
	cmp bx,8
	jnz stm

; ----- nastaveni akt polozky -----

	mov ax,[bow]	
	add ax,2
	call setbeg

	xor dx,dx	; aktualni polozka
	mov bh,cr
	call prebar	; nastaveni prvni polozky jako aktualni
	mov byte [barva],w
	call typ	; vypsani info o prvni polozce	

; ------- pohyb v menu -----

check:	mov ah,8
	int 21h
	cmp al,27
	jz end
	and al,0FFh
	jnz check	; nejaka jina klavesa
	int 21h
	cmp al,50h
	jz down
	cmp al,48h
	jz up
	jmp check
down:	cmp dl,7
	jz check
	mov bh,cb
	call prebar
	inc dl
	mov bh,cr
	call prebar
	call typ
	jmp check
up:	cmp dl,0
	jz check
	mov bh,cb
	call prebar
	dec dl
	mov bh,cr
	call prebar
	call typ
	jmp check

; ----- konec programu -----

end:	pop ax		;
	int 10h		; nastaveni puvodniho rezimu graficke karty
	ret		; konec programu

; --------------podprogramy ----------------

prtstr	push ax
	mov AH,[barva]	; vypis stringu - zacatek v SI, barva v BARVA, pozice na obrazovce v DI
	cld
sprtstr:lodsb	
	cmp al,'$'
	jz eprtstr
	stosw
	jmp sprtstr
eprtstr:pop ax
	ret

prtrstr	push ax		; vypis rev stringu - zacatek v SI, pozice na obrazovce v DI, delka v CX
	mov AH,[barva]	
	cld
sprst:	lodsb
	push ax
	lodsb	
	stosw
	pop ax
	stosw
	loop sprst
eprst:	pop ax
	ret

prt10	cld		; vypis v 10 soustave, cislo v AX, barva BARVA, pozice na obrazovce v DI
	push ax
	push bx
	push cx
	push dx
	mov bx,10	
	mov cx,1
s1:	xor dx,dx
	div bx
	and ax,ax
	push dx
	jz prt10s
	inc cx
	jmp s1
prt10s:	pop ax
	add ax,'0'
	mov ah,[barva]
	stosw
	loop prt10s
	pop dx
	pop cx
	pop bx
	pop ax
	ret

prtd10	cld		; vypis v 10 soustave, cislo v EAX, barva BARVA, pozice na obrazovce v DI
	push eax
	push ebx
	push cx
	push edx
	mov ebx,10	
	mov cx,1
sd1:	xor edx,edx
	div ebx
	and eax,eax
	push dx
	jz prtd10s
	inc cx
	jmp sd1
prtd10s:pop ax
	add ax,'0'
	mov ah,[barva]
	stosw
	loop prtd10s
	pop edx
	pop cx
	pop ebx
	pop eax
	ret
	
eoln	push bx 	; modifikuje DI
	push dx
	xor dx,dx
	xchg ax,di	
	mov bx,160
	div bx
	xor dx,dx
	mul bx
	add ax,160
	mov bx,[bol]
	add ax,bx
	xchg ax,di
	pop dx
	pop bx
	ret

prebar	cld		; v DX index v BH barva	
	push dx
	push cx
	push di
	push bx
	push ax
	and bh,0F0h
	mov cx,13
	mov ax,160
	mul dx
	mov dx,[bot]
	add ax,dx
	xchg ax,di
nxtpr:	inc di
	mov al,[ES:di]
	and al,0Fh
	xor al,bh	
	stosb
	loop nxtpr
	pop ax
	pop bx
	pop di
	pop cx
	pop dx
	ret
	
setbeg	mov di,ax	; nastavi pocatecni bod vykreslovani, nastavi DI a BOL, akt zac dat do ax
	xor dx,dx
	mov bx,160
	div bx
	mov word [bol],dx
	ret

typ	push si		; detekce vybrane polozky z menu a vola vypis
	push ax
	push dx
	call clrw
	mov si,dx
	mov al,[mystat + si]
	shr al,1	; test ide
	jnc nxt1
	mov si,cni
	call prtstr
	jmp endtyp
nxt1:	shr al,1	; test drive
	jnc nxt2
	mov si,dni
	call prtstr
	jmp endtyp
nxt2:	shr al,1
	mov si,ata
	jnc patpi
	mov si,atapi
patpi:	call prtstr
	call eoln
	xor ah,ah
	mov dx,512
	mul dx
	add ax,buf
	mov word [bufakt],ax
	call vypidf
endtyp:	pop dx
	pop ax
	pop si
	ret


clrw	push si		; vymazani plochy window a nastaveni kurzoru na pocatek
	push ax
	push bx
	push dx
	mov bx,160
	mov ah,w
	mov al,' '
	mov di,[bow]
	mov cx,1260	; rozsah okna
stclr:	push ax
	mov ax,di
	xor dx,dx
	div bx
	cmp dx,0
	jnz neoln
	add di,40	; konec radku -> novy posun o odsazeni
neoln:	pop ax
	stosw
	loop stclr
	mov di,[bow]	; nastavi zacatek
	add di,2
	pop dx
	pop bx
	pop ax
	pop si
	ret


vypidf	push si		; samotny vypis idetifikace
	push cx	
	push ax

	
	mov si,mn	; model number
	call prtstr
	mov ax,[bufakt]
	add ax,54	; bufakt + offset
	xchg ax,si
	mov cx,20
	call prtrstr

	call eoln

	mov si,sn	; serial number
	call prtstr
	mov ax,[bufakt]
	add ax,20	; bufakt + offset
	xchg ax,si
	mov cx,10
	call prtrstr

	call eoln

	mov si,fr	; firmware revision
	call prtstr
	mov ax,[bufakt]
	add ax,46	; bufakt + offset
	xchg ax,si
	mov cx,4
	call prtrstr

	call eoln
	call eoln

	mov si,nc	; number of logical cylinders
	call prtstr
	mov bx,[bufakt]
	add bx,2
	mov ax,[bx]
	call prt10

	call eoln

	mov si,nh	; number of logical heads
	call prtstr
	mov bx,[bufakt]
	add bx,6
	mov ax,[bx]
	call prt10

	call eoln

	mov si,ns	; number of logical sectors
	call prtstr
	mov bx,[bufakt]
	add bx,12
	mov ax,[bx]
	call prt10

	call eoln

	mov si,ccs	; current capacity in sectors
	call prtstr
	mov bx,[bufakt]
	add bx,114
	mov eax,[bx]
	call prtd10

	call eoln

	mov si,cc	; current capacity in sectors
	call prtstr
	shr eax,11
	call prtd10
	mov si,mb
	call prtstr

	call eoln

	mov si,nas	; total number of addressable sectors
	call prtstr
	mov bx,[bufakt]
	add bx,120
	mov eax,[bx]
	call prtd10

	call eoln

	mov si,ccl	; current capacity in MB 
	call prtstr
	shr eax,11
	call prtd10
	mov si,mb
	call prtstr



	call eoln
	call eoln

	mov bx,[bufakt]
	add bx,160	; bufakt + offset
	mov ax,[bx]
	xor cx,cx
	inc ax
	jz w80
	dec ax 
w80:	shr ax,1
	jnc ew80
	push ax
	mov ax,cx
	mov si,sa
	call prtstr
	call prt10
	pop ax
	call eoln
ew80:	inc cx
	cmp cx,15
	jnz w80
nots:	

	pop ax	
	pop cx
	pop si
	ret		; konec vypidf


; ---------------- hlasky ------------------

m	db	' master $'
s	db	' slave  $'
ide	db	' IDE$'
dni	db	'Drive is not installed on this IDE chanel$'
cni	db	'IDE controller is not installed$'
ata	db	'ATA device$'
atapi	db	'ATAPI device$'
nc	db	'Number of logical cylinders: $'
nh	db	'Number of logical heads:     $'
ns	db	'Number of logical sectors:   $'
ccs	db	'Curent capacity in sectors:  $'
ccl	db	'Curent capacity (LBA mode):  $'
cc	db	'Curent capacity:  $'	
sn	db	'Serial number: $'
fr	db	'Firmware revision: $'
mn	db	'Model number: $'
nas	db	'User addressable sectors (LBA mode): $'
sa	db	'Supports ATA-$'
mb	db	'MB$'
topl	db	'IDE identifikator (semestralni prace SOJ) - Michal Trs$'
botl	db	'Esc = Exit   Up arrow, Down arrow = move in menu$'

; --------------- barvy & vypis-------------

bol	dw	42		;pozor 1 znak = 2B
bot 	dw	330
bow	dw	360
mi	equ	00011110b	; menu item
mins	equ	00010110b	; menu item not selected
cb	equ	1Fh
cr	equ	4Fh
barva	db	01110001b
w	equ	01110000b

; ----------------- data -------------------


rdreg	dw	1F0h, 170h, 1E8h, 168h 
streg	dw	1F6h, 176h, 1EEh, 16Eh 
mystat	db	3, 3, 3, 3, 3, 3, 3, 3
bufoff	db 	-1
bufakt 	dw 	0

buf: