#*************************************#
#* Tomas Lusk, Michal Simek (C) 2005 *#
#*************************************#

# NOTE - most macros except of PRINT_* modify r12 and r14

#---------------------------
# general macros for creating other macros

# stores register on the top of stack
.macro _SGR reg
	;;
	st8 [r12] = \reg , -8
	;;
.endm

# restores register from stack
.macro _RGR reg
	;;
	ld8 \reg = [r12], 8
	;;
.endm

# stores fp register on the top of stack
.macro _SFR_E reg
	;;
	stfe [r12] = \reg , -16
	;;
.endm

# restores fp register from stack
.macro _RFR_E reg
	;;
	ldfd \reg = [r12], 16
	;;
.endm


# stores fp register on the top of stack
.macro _SFR_D reg
	;;
	stfd [r12] = \reg , -8
	;;
.endm

# restores fp register from stack
.macro _RFR_D reg
	;;
	ldfd \reg = [r12], 8
	;;
.endm

# stores fp register on the top of stack
.macro _SFR_S reg
	;;
	stfs [r12] = \reg , -8
	;;
.endm

# restores fp register from stack
.macro _RFR_S reg
	;;
	ldfs \reg = [r12], 8
	;;
.endm


# stores value on stack
.macro _SNUM val
	;;
	adds r14 = \val, r0
	;;
	st8 [r12] = r14, -8
	;;
.endm

# add to stack pointer
.macro _ASP val
	;;
	adds r12 = \val, r12
	;;
.endm

# calls function
.macro _CALL func
	;;
	br.call.sptk.many b0 = \func
	;;
.endm
	
#-------------------------------
# macros for saving and restoring global register before function call
# saved : r1 r2 r3 r8 r9 r10 r11 r12 r14-r31 b0
# modified (after POP returned to previous state) : r12 r14
#   for reading values of these registers between _PUSHA and _POPA 
#   you should use macros _SGR_R12 and _SGR_14 instead of _SGR

.macro _PUSHA
	_ASP 8
	_SGR r1
	_SGR r2
	_SGR r3
	_SGR r8
	_SGR r9
	_SGR r10
	_SGR r11
	# nothing to do for r12
	_SGR r14
	_SGR r15
	_SGR r16
	_SGR r17
	_SGR r18
	_SGR r19
	_SGR r20
	_SGR r21
	_SGR r22
	_SGR r23
	_SGR r24
	_SGR r25
	_SGR r26
	_SGR r27
	_SGR r28
	_SGR r29
	_SGR r30
	_SGR r31
	
	mov r14 = b0
	_SGR r14
	
	# reserve & align to 16B - 8 is from previous macro
	_ASP -8
.endm


.macro _POPA
	# skip free space
	_ASP 16
	
	_RGR r14
	mov b0 = r14
	
	_RGR r31
	_RGR r30
	_RGR r29
	_RGR r28
	_RGR r27
	_RGR r26
	_RGR r25
	_RGR r24
	_RGR r23
	_RGR r22
	_RGR r21
	_RGR r20
	_RGR r19
	_RGR r18
	_RGR r17
	_RGR r16
	_RGR r15
	_RGR r14
	# nothing to do for r12
	_RGR r11
	_RGR r10
	_RGR r9
	_RGR r8
	_RGR r3
	_RGR r2
	_RGR r1
	
	# restore reserve
	_ASP -16
.endm

# stores r12 - shift is number of previous stack stores in 1B units
.macro _SGR_R12 shift
	;;
	adds r14 = 208 + \shift , r12
	;;
	st8 [r12] = r14, -8
	;;
.endm

# the same for r14
.macro _SGR_R14 shift
	;;
	adds r12 = (160 + \shift), r12
	;;
	ld8 r14 = [r12]
	;;
	adds r12 = (-160 - \shift), r12
	;;
	st8 [r12] = r14, -8
	;;
.endm

#-------------------------------
# macros for printig selected registers


# print new line
.macro PRINT_NL
	_PUSHA
	_SNUM 1024
	_ASP -8
	_CALL print_arraySP#
	_ASP 16
	_POPA
.endm


# print horizontal line
.macro PRINT_HR
	_PUSHA
	_SNUM 1025
	_ASP -8
	_CALL print_arraySP#
	_ASP 16
	_POPA
.endm




# include auto generated macro file
.include "macrogen.s"
