/*************************************/
/* Tomas Lusk, Michal Simek (C) 2005 */
/*************************************/

#include "printlib.h"
#include "printers.h"
#include <stdio.h>

// returns new printer for this mode
Printer * PrinterFactory(int64 data[])
{
  switch(data[0])
  {
  // put your formater here
  PFI(0, P_GRset(32,0,"r"))
  PFI(1, P_GRset(32,32,"r"))
  PFI(2, P_GRset(32,64,"r"))
  PFI(3, P_GRset(32,96,"r"))
  PFI(4, P_Rone())
  PFI(5, P_FoneS())
  PFI(6, P_FoneD())
  PFI(7, P_FoneE())
  PFI(1024, P_NL())
  PFI(1025, P_HR())
  }
  return 0;
}


// std output object
struct StdWriter : public Writer
{
  void Write(const std::string &text) { printf("%s", text.c_str()); }
  int Width() { return 79; }
};


// print function called from asm (e.g. from printasm.s)
extern "C" void print_array(int64 data[])
{
  StdWriter stdw;
  
  Printer *p = PrinterFactory(data);
  if(!p) { printf("--- Unknown command ---\n"); return; } // unrecognized mode

  p->Write(stdw); // print data
    
  delete p; // remove allocated printer
}
