	; =======================================================
	; Semafor.Asm    Version 1.0
	;
	; Jednoduchy program ovladajici pripravek SEMAFOR
	; 
	; Copyright (c) March 2000    Pavel Janda, Jiri Vlkovsky
	; =======================================================

; Vyuziti registru a zasobniku:
;	AX - na data z tabulek, pro jine pouziti
;	BX - stav prepinace 1 (=0 - denni rezim, <>0 - nocni rezim)
;	CX - pocet opakovani jedno sekundove smycky
;	DX - pro vstupy nebo vystupy z portu LPT1
;	SI - index do tabulky Vozidla
;	DI - index do tabulky Chodci
;	vrchol zasobniku - stav indikacnich diod

	.MODEL Small
	.STACK 100h

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-( Kodovy segment )=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

	.CODE
; Tabulka pro rizeni semaforu pro vozidla
Vozidla dw 1000100000100010b	; VZ=Cervena       SJ=Zelena
	dw 1001100100100010b	; VZ=Cervena+sipka SJ=Zelena
	dw 0100010001000100b	; VZ=zluta         SJ=zluta
	dw 0010001010001000b	; VZ=Zelena        SJ=Cervena
	dw 0010001010011001b	; VZ=Zelena	   SJ=Cervena+sipka
	dw 0100010001000100b	; VZ=zluta         SJ=zluta
	dw 0000000000000000b	; VZ=Zhasnuto	   SJ=Zhasnuto
	;  CzZOCzZOCzZOCzZO	(C=Cervena, z=zluta, Z=Zelena,
	;  < Z>< V>< S>< J>	 O=Odboceni doprava)

; Tabulka pro rizeni semaforu pro chodce
Chodci	db 01011010b		; VZ=Zelena	   SJ=Cervena
	db 10101010b		; VZ=Cervena	   SJ=Cervena
	db 10101010b		; VZ=Cervena	   SJ=Cervena
	db 10100101b		; VZ=Cervena	   SJ=Zelena
	db 10101010b		; VZ=Cervena	   SJ=Cervena
	db 10101010b		; VZ=Cervena	   SJ=Cervena
	db 00000000b		; VZ=Zhasnuto	   SJ=Zhasnuto
	;  CZCZCZCZ 
	;   Z V S J

; Tabulka prirazujici odpovidajicim radkum tabulek Vozidla a Chodci dobu
; setrvani na semaforech v nasobcich sekund
Cas	dw 0000000000000100b	; VZ=Cervena       SJ=Zelena	    - trva 4s
	dw 0000000000000100b	; VZ=Cervena+sipka SJ=Zelena	    - trva 4s
	dw 0000000000000010b	; VZ=zluta         SJ=zluta	    - trva 2s
	dw 0000000000001010b	; VZ=Zelena        SJ=Cervena	    - trva 10s
	dw 0000000000000100b	; VZ=Zelena	   SJ=Cervena+sipka - trva 4s
	dw 0000000000000010b	; VZ=zluta         SJ=zluta	    - trva 2s


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-( Zacatek programu )=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
Start:				; ZACATEK hlavniho programu
	xor	ax, ax		; Pocatecni stav indikacnich diod je ulozen
	push	ax		; do zasobniku
	mov	dx, 378h	; Nastaveni vystupni brany
	mov	al, 01h		; Zapsani konstanty 01h pro cteni brany 379h
	out	dx, al
	mov	dx, 379h	; Nastaveni vstupni brany
	in	al, dx		; Nacteni stavu prepinacu do registru AL
	and	al, 01000000b	; Zamaskovani stavu prepinacu (chceme jen 1.)
	xor	bx, bx		; Nulovani BX
	mov	bl, al		; V BX se uchovava stav prepinace 1
	
	cmp	bl, 0h		; Je-li prepinac v nule, nastaveni denniho
	jz	Denni		; rezimu, jinak nastaveni nocniho rezimu
Nocni:	mov	si, 0Ah		; Nastaveni indexovych registru podle zvole-
	mov	di, 06h		; neho rezimu
	jmp	HlCast
Denni:	xor	si, si
	xor	di, di

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

; Nastaveni semaforu
HlCast:	mov	ax, Vozidla[si]	; Nacteni slova z tabulky Vozidla
	call	VSend		; Odeslani na semafor pro vozidla
	mov	al, Chodci[di]	; Nacteni bytu z tabulky Chodci
	call	ChSend		; Odeslani na semafor pro chodce
; Nacteni doby cekani (pocet opakovani je v CX)
	cmp	bl, 0h		; Je denni rezim nebo nocni?
	jz	jeDen		; .. je denni, skok
jeNoc:	mov	cx, 1h		; .. je nocni, cekani jen sekundu
	jmp	Cekej
jeDen:	mov	cx, Cas[si]	; Pocet pruchodu cekaci smyckou se nacte
				; z tabulky Cas
Cekej:	call	Delay		; Cekani

	add	si, 2h		; Inkrementace indexovych registru
	inc	di

; Kontrola a upraveni hodnot indexovych registru
	cmp	bl, 0h		; Je-li prepinac v nule, nastaveni se provede
	jz	Den		; pro denni rezim, jinak pro nocni rezim

Noc:	cmp	si, 0Eh		; Porovnani, jestli je SI v povolenem rozsahu
	jl	Noc1		; (skok pri mensim) pokud ano, nic se nedela
	mov	si, 0Ah		; Pokud ne, SI se nastavi na 10
Noc1:	mov	di, 06h		; Nastaveni DI "natvrdo" na 06h, protoze se
				; v noci pouziva jen jeden radek tabulky Chodci
	jmp	Diody

Den:	cmp	si, 0Ch		; Porovnani, jestli je SI v povolenem rozsahu
	jl	Den1		; (skok pri mensim) pokud ano, nic se nedela
	xor	si, si		; Pokud ne, SI se nastavuje na zacatek tabulky
	pop	ax		; Inkrementace stavu diod o jednicku
	inc	ax		; (Prave se vystridaly vsechny stavy semaforu)
	cmp	ax, 10h		; Porovnani, jestli nedoslo k preteceni citace
	jl	Uloz
	xor	ax, ax		; Pokud ano, citac se nuluje
Uloz:	push	ax		; Zapsani stavu diod zpet do zasobniku

Den1:	cmp	di, 06h		; Porovnani, jestli je DI v povolenem rozsahu
	jl	Diody		; pokud ano, nic se nedela
	xor	di, di		; pokud ne, DI se nuluje

; Zobrazeni stavu diod
Diody:	cmp	bl, 0h		; Je denni rezim nebo nocni?
	jz	dden		; .. je denni, skok
DNoc:	xor	ax, ax		; .. je nocni, diody se zhasnou
	jmp	Posli			
DDen:	pop	ax		; Nacteni stavu diod ze zasobniku
	push	ax

Posli:	call	DSend		; Zapsani stavu diod do pripravku

	jmp	HlCast		; Vse je obslouzeno, pokracuje se dalsim
				; stavem

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-( procedura DELAY )-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

Delay	PROC			; Aktivni cekani
	mov	dx, 378h	; Nastaveni vystupni brany (pro pozdejsi cteni)
	mov	al, 01h		; Zapsani konstanty 01h pro cteni brany 379h
	out	dx, al

PocSec: mov	dx, 002FFh	; Cekaci smycka (upravou tohoto radku se meni
				; delka trvani vnejsi smycky na 1s) !!!!!!
Vnejsi:	mov	ax, 0FFFFh
Vnitr:	dec	ax
	jnz	Vnitr
; Kontrola na zmenu stavu prepinace 1
	push	dx		; Schovani obsahu registru dx
	mov	dx, 379h	; Nastaveni vstupni brany
	in	al, dx		; Nacteni stavu prepinacu do reg. AL
	and	al, 01000000b	; Zamaskovani stavu prepinacu

	cmp	bl, al		; Porovnani stareho a noveho stavu prepinace 1
	jz	Nic		; Zadna zmena, pokracovani ve vnejsim cyklu
	jg	NocDen		; Prepnuti nocniho rezimu na denni
DenNoc:				; Prepnuti denniho rezimu na nocni
	mov	si, 08h		; Nove nastaveni indexovych registru
	mov	di, 05h		; (nastaveni pocita s pozdejsi inkrementaci)
	jmp	Zmena

NocDen:	mov	si, 0FFFEh	; Nove nastaveni indexovych registru
	mov	di, 0FFFFh	; (nastaveni pocita s pozdejsi inkrementaci)

Zmena:	pop	dx		; Uklizeni a ulozeni stavu prepinace 1
	mov	bl, al
	jmp	Vyskok		; Ukonceni procedury

Nic:	pop	dx		; Obnoveni obsahu DX
	dec	dx		; Dekrementace		
	jnz	Vnejsi		; Opakovani vnejsi smycky dokud DX<>0
	loop	PocSec		; Opakovani sekundove cekaci doby dokud CX<>0

Vyskok:	ret
Delay	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-( procedura VSEND )-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

VSend	PROC			; Vyslani 16-ti bitove hodnoty z AX
	mov	dx, 378h	; Adresa vystupni brany LPT1:
	mov	cx, 10h		; Citac pruchodu
	not	ax		; Negace AX (0=nesviti, 1=sviti)
VCykl:	ror	ax, 1h		; Vlastni cykl pro vyslani obsahu AX
	jc	VJedna		; Bit k odeslani = 1?
	call	VSend0		; ... ne, vysli 0
	jmp	VSkip                    
VJedna:	call	VSend1		; ... ano, vysli 1
VSkip:	loop	VCykl		; a pokracuj s dalsi rotaci AX
	ret
VSend	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

VSend0	PROC			; Zapis hodnoty 0 do pos. registru vozidel
	push	ax
	mov	al, 00000000b	; Data=0, hodiny=0
	out	dx, al
	mov	al, 00000010b	; Data=0, hodiny=1 (nabezna hrana)
	out	dx, al
	pop	ax
	ret
VSend0	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

VSend1	PROC			; Zapis hodnoty 1 do pos. registru vozidel
	push	ax
	mov	al, 00000001b	; Data=1, hodiny=0
	out	dx, al
	mov	al, 00000011b	; Data=1, hodiny=1 (nabezna hrana)
	out	dx, al
	pop	ax
	ret
VSend1	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-( procedura CHSEND )=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

ChSend	PROC			; Vyslani 8-i bitove hodnoty z AL
	mov	dx, 378h	; Adresa vystupni brany LPT1:
	mov	cx, 08h		; Citac pruchodu
	not	ax		; Negace AX (0=nesviti, 1=sviti)
ChCykl:	ror	ax, 1h		; Vlastni cykl pro vyslani obsahu AX
	jc	ChJedna		; Bit k odeslani = 1?
	call	ChSend0		; ... ne, vysli 0
	jmp	ChSkip                    
ChJedna: call	ChSend1		; ... ano, vysli 1
ChSkip:	loop	ChCykl		; a pokracuj s dalsi rotaci AX
	ret
ChSend	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

ChSend0	PROC			; Zapis hodnoty 0 do pos. registru chodcu
	push	ax
	mov	al, 00000000b	; Data=0, hodiny=0
	out	dx, al
	mov	al, 00001000b	; Data=0, hodiny=1 (nabezna hrana)
	out	dx, al
	pop	ax
	ret
ChSend0	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

ChSend1	PROC			; Zapis hodnoty 1 do pos. registru chodcu
	push	ax
	mov	al, 00000100b	; Data=1, hodiny=0
	out	dx, al
	mov	al, 00001100b	; Data=1, hodiny=1 (nabezna hrana)
	out	dx, al
	pop	ax
	ret
ChSend1	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-( procedura DSEND )-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

DSend	PROC			; Vyslani 4-r bitove hodnoty z AL
	mov	dx, 378h	; Adresa vystupni brany LPT1:
	mov	cx, 04h		; Citac pruchodu
	not	ax		; Negace AX (0=nesviti, 1=sviti)
DCykl:	ror	ax, 1h		; Vlastni cykl pro vyslani obsahu AX
	jc	DJedna		; Bit k odeslani = 1?
	call	DSend0		; ... ne, vysli 0
	jmp	DSkip                    
DJedna:	call	DSend1		; ... ano, vysli 1
DSkip:	loop	DCykl		; a pokracuj s dalsi rotaci AX
	ret
DSend	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

DSend0	PROC			; Zapis hodnoty 0 do pos. registru diod
	push	ax
	mov	al, 00000000b	; Data=0, hodiny=0
	out	dx, al
	mov	al, 00100000b	; Data=0, hodiny=1 (nabezna hrana)
	out	dx, al
	pop	ax
	ret
DSend0	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

DSend1	PROC			; Zapis hodnoty 1 do pos. registru diod
	push	ax
	mov	al, 00010000b	; Data=1, hodiny=0
	out	dx, al
	mov	al, 00110000b	; Data=1, hodiny=1 (nabezna hrana)
	out	dx, al
	pop	ax
	ret
DSend1	ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

	END Start

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-( Konec programu )=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-==-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=