        .MODEL small
        .STACK 100h

     ; =======================================================================
     ; Uloha c.5
	 ;
	 ; Automaticke rizeni krizovatky normalni zpusobem (tj. vzdy v jednom 
	 ; a potom ve druhem smeru) vcetne odbocovacich sipek vpravo. 
	 ; Odbocovaci sipka umozni odboceni v posledni fazi cervene v danem smeru.
	 ; Tlacitko simuluje pozadavek chodcu na prechod. Po stisku tlacitka 
	 ; je dokoncen cyklus a signaly krizovatky se nastavi tak, aby mohli
	 ; prechazet chodci po obou rovnobeznych prechodech.
	 ; 
	 ; Pozn.: prodleva pro chodce alespon 5s.
     ; =======================================================================

        .CODE
		
auta     dw     0111011111011101b       ; VZ=Cervena       SJ=Zelena
         dw     0110011011011101b		; VZ=Cervena+sipka SJ=Zelena
	 dw     0011001110111011b       ; VZ=Cervena+zluta SJ=zluta
         dw     1101110101110111b       ; VZ=Zelena        SJ=Cernena
	 dw	1101110101100110b       ; VZ=Zelena        SJ=Cernena+sipka
         dw     1011101100110011b       ; VZ=zluta         SJ=Cervena+zluta
         ;      CzZOCzZOCzZOCzZO        (O=Odboceni_doprava)
         ;      < Z>< V>< S>< J>

chodci   db	10100101b		; VZ=Zelena	SJ=Cervena
	 db	01011010b		; VZ=Cervena	SJ=Zelena
	 db	01010101b		; VZ=Cervena	SJ=Cervena

tlac	 db	00011000b		; maska tlacitka SJ
	 db	01100000b		; maska tlacitka ZV


start:   mov  si,0                      ; Zacatek hlavniho programu
	 mov  di,0
dalsi:   mov  ax,auta[si]		; Nacteni slova z tabulky
         call vsend                     ; Odeslani na semafor pro vozidla
         push ax
         mov  al,chodci[di]
         call chsend			; Odeslani na semafor pro chodce
         pop  ax
         mov  cx,0100h                  ; Pocet pruchodu cekaci smyckou = prodleva pro chodce
         call delay                     ; Cekani

	 mov  ah,255			; Nastaveni pocku kontrol zmacknuti tlacitka
cekej:	 mov  cx,200h			; Cekani
         call delay
	 call nacti			; Nacte tlacitka do AL
	 and  al,tlac[di]		; vymaskovani tlacitek
	 cmp  al,tlac[di]		; Porovna stav tlacitek s maskou		
	 jnz  zmena			; Zmacknuto tlacitko u prechodu kde je Cervena
	 dec ah
	 jnz cekej			; pokud ne, znovu zkontroluj tlacitka
		 	

         add  si,2                      ; Uprava indexregistru - odbocovaci spika
         mov  ax,auta[si]
         call vsend
         mov  cx,0c000h			; Delka odbocovaci sipky
         call delay
         sub  si,2			; Uprava indexregistru - pro pripad ze se tento stav preskocil
         
zmena:	 add  si,4			; Priprava na zmenu jizdy na krizovatce
         mov  ax,auta[si]
         call vsend
         push ax
         mov  al,chodci[2]		; Vsude na prechodu bude cervena
         call chsend			; Odeslani na semafor pro chodce
         pop  ax
         mov  cx,0c000h			; Nastaveni delky oranzove
         call delay

         add  si,2
         add  di,1
         cmp  si,12                     ; Uz jsme odeslali vsech 6 slov?
         jnz  dalsi                     ; ... ne, nacteme dalsi

         call nactip			; nacteni stavu prepinacu
         and  al,01111000b		; byl nektery prepinac zapnut?
         jnz  konec			; pokud ano, ukonci program

         jmp  start                     ; na krizovatce probehly vsechny stavy, tj. zacni od zacatku

konec:   mov ah,4Ch			; konec programu
         int 21h


delay:   push ax                        ; Aktivni cekani
vnejsi:  mov  ax,0ffffh
vnitrni: dec  ax
         jnz  vnitrni
         loop vnejsi
         pop  ax
         ret


vsend:                                  ; Vyslani 16-ti bitove hodnoty z AX
         mov  dx,378h                   ; Adresa vystupni brany LPT1:
         mov  cx,10h                    ; Citac pruchodu
vcykl:   ror  ax,1			; Vlastni cykl pro vyslani obsahu AX
         jc   vjedna			; Bit k odeslani = 1?
         call vsend0                    ; ... ne, vysli 0
         jmp  vskip                    
vjedna:  call vsend1                    ; ... ano, vysli 1
vskip:   loop vcykl                     ; a pokracuj s dalsi rotaci AX
         ret

vsend0:  push ax                        ; Zapis hodnoty 0 do pos. registru
         mov  al,0                      ; Data=0, hodiny=0
         out  dx,al
         mov  al,2                      ; Data=0, hodiny=1 (nabezna hrana)
         out  dx,al
         pop  ax
         ret

vsend1:  push ax                        ; Zapis hodnoty 1 do pos. registru
         mov  al,1                      ; Data=1, hodiny=0
         out  dx,al
         mov  al,3              	; Data=1, hodiny=1 (nabezna hrana)
         out  dx,al
         pop  ax
         ret

nacti:	 mov  al,04h			; konstanta pro cteni tlacitek	
	 mov  dx,378h			; nastaveni vystupni brany
	 out  dx,al	
	 mov  dx,379h
	 in   al,dx			; nacteni stavu tlacitek do AL
	 ret

chsend: 				; Vyslani 8-i bitove hodnoty z AL
	mov	dx, 378h		; Adresa vystupni brany LPT1:
	mov	cx, 08h			; Citac pruchodu
	
chcykl:	ror	ax, 1h			; Vlastni cykl pro vyslani obsahu AX
	jc	chjedna			; Bit k odeslani = 1?
	call	chsend0			; ... ne, vysli 0
	jmp	chskip                    
chjedna: call	chsend1			; ... ano, vysli 1
chskip:	loop	chcykl			; a pokracuj s dalsi rotaci AX
	ret

chsend0:				; Zapis hodnoty 0 do pos. registru chodcu
	push	ax	
	mov	al, 00000000b		; Data=0, hodiny=0
	out	dx, al
	mov	al, 00001000b		; Data=0, hodiny=1 (nabezna hrana)
	out	dx, al
	pop	ax
	ret

chsend1:				; Zapis hodnoty 1 do pos. registru chodcu
	push	ax
	mov	al, 00000100b		; Data=1, hodiny=0
	out	dx, al
	mov	al, 00001100b		; Data=1, hodiny=1 (nabezna hrana)
	out	dx, al
	pop	ax
	ret

nactip: mov al,01h			; konstanta pro cteni prepinacu
        mov dx,378h
        out dx,al
        mov dx,379h
        in  al,dx
        ret

         END start
