unit DataStr;


interface
uses parser, MeziTab;
const
  MAXDOORS = 15;

type
   tMeet = word;
  tStr = integer;
  tCon = integer;
  tLive = integer;
  tAttack = word;
  tDef = word;
  tExp = longint;


  UkItem = ^tItem;
  tItem = record
    name: string;
    desc: string;
    meet: tMeet;
    str: tStr;
    con: tCon;
    def: tDef;
    Attack: tAttack;
    live: tLive;
    curLive: tLive;
    put: byte;
    endG: boolean;
    Next: UkItem;
  end; {tItem}

  UkCreature = ^tCreature;
  tCreature = record
    name: string;
    desc: string;
    meet: tMeet;
    agr: word;
    str: tStr;
    con: tCon;
    live: tLive;
    attack: tAttack;
    def: tDef;
    Exp: tExp;
    endG: boolean;
    item: UkItem;
    Next: UkCreature;
  end; {tCreature}


  UkRoom = ^tRoom;

  tDoor = record
    jmeno: string;
    dest: UkRoom;
  end; {tDoor}

  tDoors = array [1..MAXDOORS] of tDoor;

  tDoorList = record
   Dvere: tDoors;
   pocet: byte;
  end;

  tRoom = record
    name: string;
    desc: string;
    endG: boolean;
    creature: UkCreature;
    item: UkItem;
    doors: tDoorList;
    next: UkRoom;
  end; {tRoom}


  hKoncetiny = (prava, leva, telo);
  hVystroj = array [hKoncetiny] of UkItem;

  tHero = record
    name: string;
    desc: string;
    str: tStr;
    con: tCon;
    live: tLive;
    curLive: tLive;
    attack: tAttack;
    def: tDef;
    Exp: tExp;
    lvl: byte;
    inventar: UkItem;
    vystroj: hVystroj;
    pos: UkRoom;
  end; {tHero}

  zTyp = (TypMist,TypPot,TypPred,TypHero);
  UkPolozka = ^tPolozka;
  tPolozka = record
   TypDat: zTyp;
   mistnost: UkRoom;
   potvora: UkCreature;
   predmet: UkItem;
   predchudce: UkPolozka;
  end; {polozka}


procedure Init (var Zasobnik: UkPolozka);
function Empty (Zasobnik: UkPolozka): boolean;
function Push (t: zTyp; m: UkRoom; c:UkCreature; i:UkItem; var Vrchol: UkPolozka):boolean;
function Pop (var Vrchol: UkPolozka):pointer;

procedure rLoadDoors(s: string; var dl: tDoorList);
function rNew (at: AttList; n: byte; p: pTab): UkRoom;
procedure rAdd ( nova: UkRoom; var world: UkRoom);
function rSearch (jmeno: string; svet: UkRoom): UkRoom;
procedure rInitDoors(var svet: UkRoom);
function rSearchDoor(d: string; m: UkRoom): UkRoom;

function iNew(Atrib: AttList;n: byte; p:pTab): UkItem;
function iSearch (jmeno: string; predmet: UkItem): UkItem;
procedure iAdd (novy: UkItem; var kam: UkItem);
procedure iAddToEnd (novy: UkItem; var iList: UkItem);
function iRemove (predmet: UkItem; var ItemList: UkItem): UkItem;
procedure iMove (var i, odkud, kam: UkItem);

function cNew(Atrib: AttList;n: byte; p:pTab): UkCreature;
procedure cAdd (nova: UkCreature; var kam: UkCreature);
function cRemove (potvora: UkCreature; var cList: UkCreature): UkCreature;
function cSearch (jmeno: string; potvora: UkCreature): UkCreature;



IMPLEMENTATION

{procedury a funkce zasobniku}

procedure Init (var Zasobnik: UkPolozka);
  begin
    Zasobnik:= nil;
  end; {zInit}

function Empty (Zasobnik: UkPolozka): boolean;
  begin
    Empty:= (Zasobnik = nil)
  end; {zEmplty}

function Push (t: zTyp; m: UkRoom; c:UkCreature; i:UkItem; var Vrchol: UkPolozka):boolean;
    var
     nova: UkPolozka;
  begin
    new(nova);
    with nova^ do
    begin
      typDat:= t;
      mistnost:= m;
      potvora:= c;
      predmet:= i;
    end;
    nova^.predchudce:= vrchol;
    Vrchol:= nova;
  end; {zPush}

function Pop (var Vrchol: UkPolozka):pointer;
  begin
    Pop:= Vrchol;
    Vrchol:= Vrchol^.predchudce;
  end;


{Datovy typ mistnost}


procedure rLoadDoors(s: string; var dl: tDoorList);
  var
   n,i: byte;
  begin
    for i:= 1 to MAXDOORS do {vynulovani seznamu dveri}
    with dl.dvere[i] do
    begin
      jmeno:='';
      dest:= nil;
    end;
    n:=1;
    for i:=1 to length(s) do {nacteni dveri do seznamu}
     if s[i] <> ' ' then dl.dvere[n].jmeno:= dl.dvere[n].jmeno + s[i]
      else if  s[i-1] <> ' ' then inc(n);
    dl.pocet:= n;
  end; {rLoadDoors}


function rNew (at: AttList; n: byte; p: pTab): UkRoom;
   var
    room: UkRoom; i: byte;
  begin
     new(room);
    with room^ do
    begin
      desc:= '';
      endg:= false;
      creature:= nil;
      item:= nil;
      next:= nil;
    end;
    for i:=1 to n do
     case Preved(p,UpString(At[i].name)) of
      name:   room^.name:= At[i].value;
      dvre:   rLoadDoors(at[i].value,room^.doors);
      khry:   room^.endg:= UpString(at[i].value) = 'A'
     end; {for}
    rNew:= room;
  end; {rNew}


procedure rAdd ( nova: UkRoom; var world: UkRoom);
  begin
    nova^.next:= world;
    world:= nova;
  end; {rAdd}


function rSearch (jmeno: string; svet: UkRoom): UkRoom;
    var p: UkRoom;
  begin
    p:= svet;
    while (UpString(p^.name) <> UpString(jmeno)) and (p^.next <> nil) do
     p:= p^.next;
    rSearch:= p;
  end; {rSearch}


procedure rInitDoors(var svet: UkRoom);
  var
   p: UkRoom;
   i: byte;
  begin
   p:= svet;
   while p <> nil do
   begin
     for i:=1 to p^.doors.pocet do
      p^.doors.dvere[i].dest:= rSearch(p^.doors.dvere[i].jmeno,svet);
     p:= p^.next;
   end;
  end; {rInitDoors}

function rSearchDoor(d: string; m: UkRoom): UkRoom;
  var
   i: byte;
  begin
    rSearchDoor:= nil;
    for i:=1 to m^.doors.pocet do
     if UpString(d) = UpString(m^.doors.dvere[i].jmeno) then
      begin
        rSearchDoor:= m^.doors.dvere[i].dest;
        break;
      end
  end; {rSearchDoor}


function iNew(Atrib: AttList;n: byte; p:pTab): UkItem;
    var
     novy: UkItem;
     i:byte;
     pom,code: integer;
  begin
    new(novy);
    {nastaveni vsech hodnot parametru na nulu}
    with novy^ do
    begin
      meet:=100; str:=0; con:=0; live:=0; attack:=0; def:=0; desc:= '';
      put:=0; endg:=false; next:=nil; curLive:=0;
    end;
    for i:=1 to n do
    case preved(p,UpString(Atrib[i].name)) of
      name:   novy^.name:= atrib[i].value;
      meet:   begin
               val(Atrib[i].value,pom,code);
               novy^.meet:= pom;
              end;
      str:    begin
               val(Atrib[i].value,pom,code);
               novy^.str:= pom;
              end;
      con:    begin
               val(Atrib[i].value,pom,code);
               novy^.con:= pom;
              end;
      live:   begin
               val(Atrib[i].value,pom,code);
               novy^.live:= pom;
              end;
      curLive:begin
               val(Atrib[i].value,pom,code);
               novy^.curLive:= pom;
              end;
      attack: begin
               val(Atrib[i].value,pom,code);
               novy^.attack:= pom;
              end;
      def:    begin
               val(Atrib[i].value,pom,code);
               novy^.def:= pom;
              end;
      put:    begin
               val(Atrib[i].value,pom,code);
               novy^.put:= pom;
              end;
      khry:   novy^.endg:= UpString(Atrib[i].value) = 'A'
    end; {for}
    iNew:= novy;
  end; {iNew}


{predmet}

function iSearch (jmeno: string; predmet: UkItem): UkItem;
    var i: UkItem;
  begin
    i:= predmet;
    jmeno:= UpString(jmeno);
    while (UpString(i^.name) <> jmeno) and (i <> nil) do
     i:= i^.next;
    iSearch:= i;
  end; {iSearch}


procedure iAdd (novy: UkItem; var kam: UkItem);
  begin
    novy^.next:= kam;
    kam:= novy;
  end; {iAdd}

procedure iAddToEnd (novy: UkItem; var iList: UkItem);
  {pomale, vhodne jen pro pridani celo seznamu k jinemu}
  var
    p: UkItem;
  begin
   if iList = nil then
    iList:= novy
   else
   begin
    p:= iList;
    while p^.next <> nil do p:= p^.next;
    p^.next:= novy
   end;
  end; {iAddToEnd}


  function iRemoveBegin(var ItemList: UkItem): UkItem;
  begin
    iRemoveBegin:= ItemList;
    ItemList:= ItemList^.Next;
  end;

  function iRemove (predmet: UkItem; var ItemList: UkItem): UkItem;
  var
    zakym: UkItem;
  begin
    if ItemList = predmet then
     iRemove:= iRemoveBegin(ItemList)
    else
    begin
      zakym:= ItemList;
      while zakym^.next <> predmet do zakym:= zakym^.next;
      iRemove:= predmet;
      zakym^.next:= predmet^.next;
    end;
  end; {iRemove}


  procedure iMove (var i, odkud, kam: UkItem);
  begin
    iAdd(iRemove(i,odkud),kam);
  end; {iMove}


  function cNew(Atrib: AttList;n: byte; p:pTab): UkCreature;
    var
     nova: UkCreature;
     i:byte;
     pom,code: integer;
  begin
    new(nova);
    with nova^ do {nastaveni vsech hodnot na nulu --> pro pripad ze se
    dany parametr nenacte ze souboru}
    begin
      meet:=100; agr:=0; str:=0; con:=0; live:=0; attack:=0; def:=0; exp:=0;
      endg:=false; item:=nil; desc:=''; next:= nil;
    end;
    for i:=1 to n do
    case Preved(p,UpString(Atrib[i].name)) of
      name:   nova^.name:= atrib[i].value;
      meet:   begin
               val(Atrib[i].value,pom,code);
               nova^.meet:= pom;
              end;
      agr:    begin
               val(Atrib[i].value,pom,code);
               nova^.agr:= pom;
              end;

      str:    begin
               val(Atrib[i].value,pom,code);
               nova^.str:= pom;
              end;
      con:    begin
               val(Atrib[i].value,pom,code);
               nova^.con:= pom;
              end;
      live:   begin
               val(Atrib[i].value,pom,code);
               nova^.live:= pom;
              end;
      attack: begin
               val(Atrib[i].value,pom,code);
               nova^.attack:= pom;
              end;
      def:    begin
               val(Atrib[i].value,pom,code);
               nova^.def:= pom;
              end;
      exp:    begin
               val(Atrib[i].value,pom,code);
               nova^.exp:= pom;
              end;
      khry:   nova^.endg:= UpString(Atrib[i].value) = 'A'
    end; {for}
    cNew:= nova;
  end; {cNew}


procedure cAdd (nova: UkCreature; var kam: UkCreature);
  begin
    nova^.next:= kam;
    kam:= nova;
  end; {cAdd}


function cRemoveBegin(var cList: UkCreature): UkCreature;
  begin
    cRemoveBegin:= cList;
    cList:= cList^.Next;
  end;

function cRemove (potvora: UkCreature; var cList: UkCreature): UkCreature;
  var
    zakym: UkCreature;
  begin
    if cList = potvora then
     cRemove:= cRemoveBegin(cList)
    else
    begin
      zakym:= cList;
      while zakym^.next <> potvora do zakym:= zakym^.next;
      cRemove:= potvora;
      zakym^.next:= potvora^.next;
    end;
  end; {iRemove}


function cSearch (jmeno: string; potvora: UkCreature): UkCreature;
  begin
    jmeno:= UpString(jmeno);
    while (UpString(potvora^.name) <> jmeno) and (potvora <> nil) do
     potvora:= potvora^.next;
    cSearch:= potvora;
  end; {cSearch}





end.