unit meziTAB;

interface

const
  MAXTAB = 30;

  {prikazy nactene z klavesnice}
  P = 1; L = 2; USE = 3; TE = 5; JDI = 10; SEBER = 11;
  UTOC = 13; CHAR = 14; INV = 15; ZKOUMAT = 16;
  KOUKAM = 17; ZAHODIT = 18; KONEC = 200; NENI = 255;
  {pro prevodni tabulku souboor --> dat. struktura}
  NAME = 1; DESC = 2; MEET = 3; STR = 4; CON = 5; DEF = 6; ATTACK = 7;
  LIVE = 8; PUT = 9; EXP = 10; DVRE = 11; START = 12; KHRY = 13;
  CURLIVE = 14; AGR = 15;

type

  tRadek = record
    s: string;
    a: byte;
  end;
  pTab = array [1..MAXTAB] of tRadek;

   procedure InitTabVstup(var T: pTab);
   procedure InitTabPar(var T: pTab);
   function Preved(T: pTab; k: string): byte;



implementation

   procedure InitTabVstup(var T: pTab);
   begin
     T[1].s:= 'JDI';     T[1].a:= JDI;
     T[2].s:= 'BEZ';     T[2].a:= JDI;
     T[3].s:= 'G';       T[3].a:= JDI;
     T[5].s:= 'SEBER';   T[5].a:= SEBER;
     T[6].s:= 'ZVEDNI';  T[6].a:= SEBER;
     T[7].s:= 'T';       T[7].a:= SEBER;
     T[8].s:= 'USE';     T[8].a:= USE;
     T[9].s:= 'U';       T[9].a:= USE;
     T[10].s:= 'UTOC';   T[10].a:= UTOC;
     T[11].s:= 'ZABIJ';  T[11].a:= UTOC;
     T[12].s:= 'PAREJ';  T[12].a:= UTOC;
     T[13].s:= 'A';      T[13].a:= UTOC;
     T[14].s:= 'KOUKAM'; T[14].a:= KOUKAM;
     T[15].s:= 'L';      T[15].a:= KOUKAM;
     T[16].s:= 'CHAR';   T[16].a:= CHAR;
     T[17].s:= 'C';      T[17].a:= CHAR;
     T[18].s:= 'INV';    T[18].a:= INV;
     T[19].s:= 'I';      T[19].a:= INV;
     T[20].s:= 'ZKOUMAT';T[20].a:= ZKOUMAT;
     T[21].s:= 'UKAZ';   T[21].a:= ZKOUMAT;
     T[22].s:= 'E';      T[22].a:= ZKOUMAT;
     T[23].s:= 'ZAHOD';  T[23].a:= ZAHODIT;
     T[24].s:= 'POLOZ';  T[24].a:= ZAHODIT;
     T[25].s:= 'P';      T[25].a:= ZAHODIT;
     T[26].s:= 'PRAVA';  T[26].a:= P;
     T[27].s:= 'LEVA';   T[27].a:= L;
     T[28].s:= 'TELO';   T[28].a:= TE;
     T[29].s:= 'POUZIJ'; T[29].a:= USE;
     T[30].s:= 'KONEC';  T[30].a:= KONEC;
   end; {InitTab}

   procedure InitTabPar(var T: pTab);
   begin
     T[1].s:= 'NAME';   T[1].a:= NAME;
     T[2].s:= 'DESC';   T[2].a:= DESC;
     T[3].s:= 'MEET';   T[3].a:= MEET;
     T[4].s:= 'STR';    T[4].a:= STR;
     T[5].s:= 'CON';    T[5].a:= CON;
     T[6].s:= 'DEF';    T[6].a:= DEF;
     T[7].s:= 'ATTACK'; T[7].a:= ATTACK;
     T[8].s:= 'LIVE';   T[8].a:= LIVE;
     T[9].s:= 'PUT';    T[9].a:= PUT;
     T[10].s:= 'EXP';   T[10].a:= EXP;
     T[11].s:= 'DOORS'; T[11].a:= DVRE;
     T[12].s:= 'START'; T[12].a:= START;
     T[13].s:= 'END';   T[13].a:= KHRY;
     T[14].s:= 'CURLIVE';T[14].a:= CURLIVE;
     T[15].s:= 'AGR';   T[15].a:= AGR;
   end;


   function Preved(T: pTab; k: string): byte;
     var i: byte;
   begin
     Preved:= NENI;
     for i:= 1 to MAXTAB do
      if T[i].s = k then
      begin
        Preved:= T[i].a;
        break;
      end
   end;

end.